/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument;

import java.sql.PreparedStatement;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NullArgument;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

public class ObjectArgument
implements Argument {
    private final Object value;
    private final Integer sqlType;

    @Deprecated
    public ObjectArgument(Object object, Integer n) {
        this.sqlType = n;
        this.value = object;
        if (n == null && object == null) {
            throw new IllegalArgumentException("Null value provided without a type");
        }
    }

    public static Argument of(Object object) {
        return ObjectArgument.of(object, null);
    }

    public static Argument of(Object object, Integer n) {
        if (object == null) {
            return new NullArgument(n);
        }
        return new ObjectArgument(object, n);
    }

    @Override
    public void apply(int n, PreparedStatement preparedStatement, StatementContext statementContext) {
        if (this.value == null) {
            preparedStatement.setNull(n, this.sqlType);
        } else if (this.sqlType == null) {
            preparedStatement.setObject(n, this.value);
        } else {
            preparedStatement.setObject(n, this.value, this.sqlType);
        }
    }

    public String toString() {
        return (this.value == null ? "NULL" : String.valueOf(this.value)) + (this.sqlType == null ? "" : " (type " + this.sqlType + ")");
    }
}

