/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NamedArgumentFinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.MethodReturnValueNamedArgumentFinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.TypedValue;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCache;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCaches;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.Qualifiers;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

public class ObjectMethodArguments
extends MethodReturnValueNamedArgumentFinder {
    private static final JdbiCache<Class<?>, Map<String, Method>> NULLARY_METHOD_CACHE = JdbiCaches.declare(ObjectMethodArguments::load);

    public ObjectMethodArguments(String string, Object object) {
        super(string, object);
    }

    private static Map<String, Method> load(Class<?> clazz2) {
        if (Modifier.isPublic(clazz2.getModifiers())) {
            return Arrays.stream(clazz2.getMethods()).filter(method -> method.getParameterCount() == 0).collect(Collectors.toMap(Method::getName, Function.identity(), ObjectMethodArguments::bridgeMethodMerge));
        }
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        Optional.ofNullable(clazz2.getSuperclass()).ifPresent(clazz -> hashMap.putAll(ObjectMethodArguments.load(clazz)));
        Arrays.stream(clazz2.getInterfaces()).forEach(clazz -> hashMap.putAll(ObjectMethodArguments.load(clazz)));
        return hashMap;
    }

    @Override
    protected Optional<TypedValue> getValue(String string, StatementContext statementContext) {
        Method method = NULLARY_METHOD_CACHE.get(this.obj.getClass(), statementContext).get(string);
        if (method == null) {
            return Optional.empty();
        }
        QualifiedType<?> qualifiedType = QualifiedType.of(method.getGenericReturnType()).withAnnotations(statementContext.getConfig(Qualifiers.class).findFor(method));
        Object object = this.invokeMethod(method, statementContext);
        return Optional.of(new TypedValue(qualifiedType, object));
    }

    @Override
    protected NamedArgumentFinder getNestedArgumentFinder(Object object) {
        return new ObjectMethodArguments(null, object);
    }

    public String toString() {
        return "{lazy object functions arguments \"" + this.obj + "\"";
    }

    private static Method bridgeMethodMerge(Method method, Method method2) {
        return method.isBridge() ? method2 : method;
    }
}

