/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Arguments;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.DelegatingArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;

class OptionalArgumentFactory
extends DelegatingArgumentFactory {
    OptionalArgumentFactory() {
        this.register(OptionalInt.class, 4, (preparedStatement, n, optionalInt) -> {
            if (optionalInt.isPresent()) {
                preparedStatement.setInt(n, optionalInt.getAsInt());
            } else {
                preparedStatement.setNull(n, 4);
            }
        });
        this.register(OptionalLong.class, -5, (preparedStatement, n, optionalLong) -> {
            if (optionalLong.isPresent()) {
                preparedStatement.setLong(n, optionalLong.getAsLong());
            } else {
                preparedStatement.setNull(n, -5);
            }
        });
        this.register(OptionalDouble.class, 8, (preparedStatement, n, optionalDouble) -> {
            if (optionalDouble.isPresent()) {
                preparedStatement.setDouble(n, optionalDouble.getAsDouble());
            } else {
                preparedStatement.setNull(n, 8);
            }
        });
    }

    @Override
    public Optional<Argument> build(Type type, Object object, ConfigRegistry configRegistry) {
        if (object instanceof Optional) {
            Object var4_4 = ((Optional)object).orElse(null);
            Type type2 = OptionalArgumentFactory.findOptionalType(type, var4_4);
            return configRegistry.get(Arguments.class).findFor(type2, var4_4);
        }
        return super.build(type, object, configRegistry);
    }

    private static Type findOptionalType(Type type, Object object) {
        Optional<Type> optional;
        if (GenericTypes.getErasedType(type).equals(Optional.class) && (optional = GenericTypes.findGenericParameter(type, Optional.class)).isPresent()) {
            return optional.get();
        }
        return object == null ? Object.class : object.getClass();
    }
}

