/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal;

import java.util.Collection;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NamedArgumentFinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.MethodReturnValueNamedArgumentFinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.internal.TypedValue;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.internal.PojoTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToCreateStatementException;

public class PojoPropertyArguments
extends MethodReturnValueNamedArgumentFinder {
    private final PojoProperties<?> properties;
    private final ConfigRegistry config;

    public PojoPropertyArguments(String string, Object object, ConfigRegistry configRegistry) {
        this(string, object, configRegistry.get(PojoTypes.class).findFor(object.getClass()).orElseThrow(() -> new UnableToCreateStatementException("Couldn't find pojo type of " + object.getClass())), configRegistry);
    }

    protected PojoPropertyArguments(String string, Object object, PojoProperties<?> pojoProperties, ConfigRegistry configRegistry) {
        super(string, object);
        this.properties = pojoProperties;
        this.config = configRegistry;
    }

    @Override
    protected Optional<TypedValue> getValue(String string, StatementContext statementContext) {
        PojoProperties.PojoProperty<?> pojoProperty2 = this.properties.getProperties().get(string);
        return Optional.ofNullable(pojoProperty2).map(pojoProperty -> new TypedValue(pojoProperty.getQualifiedType(), pojoProperty.get(this.obj)));
    }

    @Override
    public Collection<String> getNames() {
        return this.properties.getProperties().keySet();
    }

    @Override
    protected NamedArgumentFinder getNestedArgumentFinder(Object object) {
        return new PojoPropertyArguments(null, object, this.config);
    }

    public String toString() {
        return "{lazy bean property arguments \"" + this.obj + "\"}";
    }
}

