/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.array;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayArgumentStrategy;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.SqlArrayType;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.IterableLike;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

class SqlArrayArgument<T>
implements Argument {
    private final String typeName;
    private final Object[] array;

    SqlArrayArgument(SqlArrayType<T> sqlArrayType, Object object) {
        this.typeName = sqlArrayType.getTypeName();
        Stream<Object> stream = IterableLike.stream(object);
        this.array = stream.map(sqlArrayType::convertArrayElement).toArray();
    }

    @Override
    public void apply(int n, PreparedStatement preparedStatement, StatementContext statementContext) {
        SqlArrayArgumentStrategy sqlArrayArgumentStrategy = statementContext.getSqlArrayArgumentStrategy();
        switch (sqlArrayArgumentStrategy) {
            case SQL_ARRAY: {
                Array array = preparedStatement.getConnection().createArrayOf(this.typeName, this.array);
                statementContext.addCleanable(array::free);
                preparedStatement.setArray(n, array);
                break;
            }
            case OBJECT_ARRAY: {
                preparedStatement.setObject(n, this.array);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown array argument style " + (Object)((Object)sqlArrayArgumentStrategy));
            }
        }
    }

    public String toString() {
        return this.typeName + "[] - " + Arrays.toString(this.array);
    }
}

