/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.array;

import java.lang.reflect.Type;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.ArrayColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.array.CollectorColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.JdbiCollectors;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMappers;

public class SqlArrayMapperFactory
implements ColumnMapperFactory {
    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry configRegistry) {
        Class<?> clazz = GenericTypes.getErasedType(type);
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            return this.elementTypeMapper(clazz2, configRegistry).map(columnMapper -> new ArrayColumnMapper((ColumnMapper<?>)columnMapper, clazz2));
        }
        JdbiCollectors jdbiCollectors = configRegistry.get(JdbiCollectors.class);
        return jdbiCollectors.findFor(type).flatMap(collector -> jdbiCollectors.findElementTypeFor(type).flatMap(type -> this.elementTypeMapper((Type)type, configRegistry)).map(columnMapper -> new CollectorColumnMapper(columnMapper, collector)));
    }

    private Optional<ColumnMapper<?>> elementTypeMapper(Type type, ConfigRegistry configRegistry) {
        Optional<ColumnMapper<?>> optional = configRegistry.get(ColumnMappers.class).findFor(type);
        if (!optional.isPresent() && type == Object.class) {
            return Optional.of((resultSet, n, statementContext) -> resultSet.getObject(n));
        }
        return optional;
    }
}

