/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.collector;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collector;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.ArrayCollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.CollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.EnumSetCollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.ListCollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.MapCollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.OptionalCollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.OptionalPrimitiveCollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.SetCollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;

public class JdbiCollectors
implements JdbiConfig<JdbiCollectors> {
    private final List<CollectorFactory> factories = new CopyOnWriteArrayList<CollectorFactory>();

    public JdbiCollectors() {
        this.register(new MapCollectorFactory());
        this.register(new OptionalCollectorFactory());
        this.register(new ListCollectorFactory());
        this.register(new SetCollectorFactory());
        this.register(new OptionalPrimitiveCollectorFactory());
        this.register(new ArrayCollectorFactory());
        this.register(new EnumSetCollectorFactory());
    }

    private JdbiCollectors(JdbiCollectors jdbiCollectors) {
        this.factories.addAll(jdbiCollectors.factories);
    }

    public JdbiCollectors register(CollectorFactory collectorFactory) {
        this.factories.add(0, collectorFactory);
        return this;
    }

    public Optional<Collector<?, ?, ?>> findFor(Type type) {
        return this.findFactoryFor(type).map(collectorFactory -> collectorFactory.build(type));
    }

    public Optional<Type> findElementTypeFor(Type type) {
        return this.findFactoryFor(type).flatMap(collectorFactory -> collectorFactory.elementType(type));
    }

    private Optional<CollectorFactory> findFactoryFor(Type type) {
        return this.factories.stream().filter(collectorFactory -> collectorFactory.accepts(type)).findFirst();
    }

    @Override
    public JdbiCollectors createCopy() {
        return new JdbiCollectors(this);
    }
}

