/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.collector;

import java.util.function.Function;
import java.util.function.Supplier;

class OptionalBuilder<T, O> {
    private final Supplier<O> empty;
    private final Function<T, O> factory;
    boolean set;
    T value;

    OptionalBuilder(Supplier<O> supplier, Function<T, O> function) {
        this.empty = supplier;
        this.factory = function;
    }

    void set(T t) {
        if (this.set) {
            throw OptionalBuilder.tooManyValues(this.value, t);
        }
        this.value = t;
        this.set = true;
    }

    O build() {
        return this.value == null ? this.empty.get() : this.factory.apply(this.value);
    }

    static <T, OPT_T> OptionalBuilder<T, OPT_T> combine(OptionalBuilder<T, OPT_T> optionalBuilder, OptionalBuilder<T, OPT_T> optionalBuilder2) {
        if (optionalBuilder.set && optionalBuilder2.set) {
            throw OptionalBuilder.tooManyValues(optionalBuilder.value, optionalBuilder2.value);
        }
        return optionalBuilder.set ? optionalBuilder : optionalBuilder2;
    }

    private static <T> IllegalStateException tooManyValues(T t, T t2) {
        return new IllegalStateException(String.format("Multiple values for optional: [%s, %s, ...]", OptionalBuilder.stringify(t), OptionalBuilder.stringify(t2)));
    }

    private static String stringify(Object object) {
        return object == null ? null : "'" + object + "'";
    }
}

