/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.collector;

import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collector;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.CollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.OptionalCollectors;

class OptionalPrimitiveCollectorFactory
implements CollectorFactory {
    private static final Map<Class<?>, Collector<?, ?, ?>> COLLECTORS = new IdentityHashMap();
    private static final Map<Class<?>, Class<?>> ELEMENT_TYPES = new IdentityHashMap();

    OptionalPrimitiveCollectorFactory() {
    }

    @Override
    public boolean accepts(Type type) {
        return type instanceof Class && COLLECTORS.containsKey(type);
    }

    @Override
    public Optional<Type> elementType(Type type) {
        return type instanceof Class ? Optional.of(ELEMENT_TYPES.get(type)) : Optional.empty();
    }

    @Override
    public Collector<?, ?, ?> build(Type type) {
        return type instanceof Class ? COLLECTORS.get(type) : null;
    }

    static {
        COLLECTORS.put(OptionalInt.class, OptionalCollectors.toOptionalInt());
        ELEMENT_TYPES.put(OptionalInt.class, Integer.class);
        COLLECTORS.put(OptionalLong.class, OptionalCollectors.toOptionalLong());
        ELEMENT_TYPES.put(OptionalLong.class, Long.class);
        COLLECTORS.put(OptionalDouble.class, OptionalCollectors.toOptionalDouble());
        ELEMENT_TYPES.put(OptionalDouble.class, Double.class);
    }
}

