/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.collector;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.jdbi.v3.core.collector.CollectorFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;

class SetCollectorFactory
implements CollectorFactory {
    private final Map<Class<?>, Collector<?, ?, ?>> collectors = new IdentityHashMap();

    SetCollectorFactory() {
        this.collectors.put(Set.class, Collectors.toSet());
        this.collectors.put(HashSet.class, Collectors.toCollection(HashSet::new));
        this.collectors.put(LinkedHashSet.class, Collectors.toCollection(LinkedHashSet::new));
        this.collectors.put(SortedSet.class, Collectors.toCollection(TreeSet::new));
        this.collectors.put(TreeSet.class, Collectors.toCollection(TreeSet::new));
    }

    @Override
    public boolean accepts(Type type) {
        return type instanceof ParameterizedType && this.collectors.containsKey(GenericTypes.getErasedType(type));
    }

    @Override
    public Optional<Type> elementType(Type type) {
        Class<?> clazz = GenericTypes.getErasedType(type);
        return GenericTypes.findGenericParameter(type, clazz);
    }

    @Override
    public Collector<?, ?, ?> build(Type type) {
        Class<?> clazz = GenericTypes.getErasedType(type);
        return this.collectors.get(clazz);
    }
}

