/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.extension;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.ExtensionFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.HandleSupplier;

public class Extensions
implements JdbiConfig<Extensions> {
    private final List<ExtensionFactory> factories = new CopyOnWriteArrayList<ExtensionFactory>();

    public Extensions() {
    }

    private Extensions(Extensions extensions) {
        this.factories.addAll(extensions.factories);
    }

    public Extensions register(ExtensionFactory extensionFactory) {
        this.factories.add(0, extensionFactory);
        return this;
    }

    public boolean hasExtensionFor(Class<?> clazz) {
        return this.findFactoryFor(clazz).isPresent();
    }

    public <E> Optional<E> findFor(Class<E> clazz, HandleSupplier handleSupplier) {
        return this.findFactoryFor(clazz).map(extensionFactory -> extensionFactory.attach(clazz, handleSupplier));
    }

    private Optional<ExtensionFactory> findFactoryFor(Class<?> clazz) {
        return this.factories.stream().filter(extensionFactory -> extensionFactory.accepts(clazz)).findFirst();
    }

    public <F extends ExtensionFactory> Optional<F> findFactory(Class<F> clazz) {
        return this.factories.stream().filter(clazz::isInstance).map(clazz::cast).findFirst();
    }

    @Override
    public Extensions createCopy() {
        return new Extensions(this);
    }
}

