/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.internal;

import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.enums.EnumByName;
import me.glaremasters.guilds.libs.jdbi.v3.core.enums.EnumByOrdinal;
import me.glaremasters.guilds.libs.jdbi.v3.core.enums.EnumStrategy;
import me.glaremasters.guilds.libs.jdbi.v3.core.enums.Enums;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.JdbiOptionals;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.Qualifiers;

public class EnumStrategies
implements JdbiConfig<EnumStrategies> {
    private ConfigRegistry registry;

    @Override
    public void setRegistry(ConfigRegistry configRegistry) {
        this.registry = configRegistry;
    }

    public <E extends Enum<E>> EnumStrategy findStrategy(QualifiedType<E> qualifiedType) {
        Class<?> clazz = GenericTypes.getErasedType(qualifiedType.getType());
        return JdbiOptionals.findFirstPresent(() -> EnumStrategies.doFindStrategy(qualifiedType), () -> EnumStrategies.doFindStrategy(QualifiedType.of(clazz).withAnnotations(this.registry.get(Qualifiers.class).findFor(clazz)))).orElseGet(() -> this.registry.get(Enums.class).getDefaultStrategy());
    }

    private static <T> Optional<EnumStrategy> doFindStrategy(QualifiedType<T> qualifiedType) {
        boolean bl = qualifiedType.hasQualifier(EnumByName.class);
        boolean bl2 = qualifiedType.hasQualifier(EnumByOrdinal.class);
        if (bl && bl2) {
            throw new IllegalArgumentException(String.format("%s is both %s and %s", qualifiedType.getType(), EnumByName.class.getSimpleName(), EnumByOrdinal.class.getSimpleName()));
        }
        if (bl) {
            return Optional.of(EnumStrategy.BY_NAME);
        }
        if (bl2) {
            return Optional.of(EnumStrategy.BY_ORDINAL);
        }
        return Optional.empty();
    }

    @Override
    public EnumStrategies createCopy() {
        return new EnumStrategies();
    }
}

