/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.sql.ResultSet;
import java.util.Arrays;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCache;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCaches;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.JdbiOptionals;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.UnableToProduceResultException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

public abstract class EnumMapper<E extends Enum<E>>
implements ColumnMapper<E> {
    EnumMapper() {
    }

    public static <E extends Enum<E>> ColumnMapper<E> byName(Class<E> clazz) {
        return new EnumByNameColumnMapper(clazz);
    }

    public static <E extends Enum<E>> ColumnMapper<E> byOrdinal(Class<E> clazz) {
        return new EnumByOrdinalColumnMapper(clazz);
    }

    static class EnumByOrdinalColumnMapper<E extends Enum<E>>
    implements ColumnMapper<E> {
        private final Class<E> enumClass;
        private final E[] enumConstants;

        private EnumByOrdinalColumnMapper(Class<E> clazz) {
            this.enumClass = clazz;
            this.enumConstants = (Enum[])clazz.getEnumConstants();
        }

        @Override
        public E map(ResultSet resultSet, int n, StatementContext statementContext) {
            int n2 = resultSet.getInt(n);
            try {
                return resultSet.wasNull() ? null : (E)this.enumConstants[n2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UnableToProduceResultException(String.format("no %s value could be matched to the ordinal %s", this.enumClass.getSimpleName(), n2), arrayIndexOutOfBoundsException, statementContext);
            }
        }
    }

    static class EnumByNameColumnMapper<E extends Enum<E>>
    implements ColumnMapper<E> {
        private static final JdbiCache<Class<? extends Enum<?>>, JdbiCache<String, Enum<?>>> BY_NAME_CACHE = JdbiCaches.declare(clazz -> JdbiCaches.declare(string -> (Enum)clazz.cast(EnumByNameColumnMapper.getValueByName(clazz, string))));
        private final Class<E> enumClass;

        private EnumByNameColumnMapper(Class<E> clazz) {
            this.enumClass = clazz;
        }

        @Override
        public E map(ResultSet resultSet, int n, StatementContext statementContext) {
            String string = resultSet.getString(n);
            return (E)(string == null || string.isEmpty() ? null : (Enum)this.enumClass.cast(BY_NAME_CACHE.get(this.enumClass, statementContext).get(string, statementContext)));
        }

        private static Object getValueByName(Class<? extends Enum<?>> clazz, String string) {
            Enum[] enumArray = clazz.getEnumConstants();
            return JdbiOptionals.findFirstPresent(() -> Arrays.stream(enumArray).filter(enum_ -> enum_.name().equals(string)).findFirst(), () -> Arrays.stream(enumArray).filter(enum_ -> enum_.name().equalsIgnoreCase(string)).findFirst()).orElseThrow(() -> new UnableToProduceResultException(String.format("no %s value could be matched to the name %s", clazz.getSimpleName(), string)));
        }
    }
}

