/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.sql.ResultSet;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.MapEntryMappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.NoSuchMapperException;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.SingleColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

public class MapEntryMapper<K, V>
implements RowMapper<Map.Entry<K, V>> {
    private static final TypeVariable<Class<Map.Entry>> KEY_PARAM;
    private static final TypeVariable<Class<Map.Entry>> VALUE_PARAM;
    private final RowMapper<K> keyMapper;
    private final RowMapper<V> valueMapper;

    static RowMapperFactory factory() {
        return (type, configRegistry) -> {
            if (type instanceof ParameterizedType && GenericTypes.getErasedType(type).equals(Map.Entry.class)) {
                Type type2 = GenericTypes.resolveType(KEY_PARAM, type);
                Type type3 = GenericTypes.resolveType(VALUE_PARAM, type);
                RowMapper<?> rowMapper = MapEntryMapper.getKeyMapper(type2, configRegistry);
                RowMapper<?> rowMapper2 = MapEntryMapper.getValueMapper(type3, configRegistry);
                return Optional.of(new MapEntryMapper(rowMapper, rowMapper2));
            }
            return Optional.empty();
        };
    }

    private static RowMapper<?> getKeyMapper(Type type, ConfigRegistry configRegistry) {
        String string = configRegistry.get(MapEntryMappers.class).getKeyColumn();
        if (string == null) {
            return configRegistry.get(RowMappers.class).findFor(type).orElseThrow(() -> new NoSuchMapperException("No row mapper registered for map key " + type));
        }
        return configRegistry.get(ColumnMappers.class).findFor(type).map(columnMapper -> new SingleColumnMapper(columnMapper, string)).orElseThrow(() -> new NoSuchMapperException("No column mapper registered for map key " + type + " in column " + string));
    }

    private static RowMapper<?> getValueMapper(Type type, ConfigRegistry configRegistry) {
        String string = configRegistry.get(MapEntryMappers.class).getValueColumn();
        if (string == null) {
            return configRegistry.get(RowMappers.class).findFor(type).orElseThrow(() -> new NoSuchMapperException("No row mapper registered for map value " + type));
        }
        return configRegistry.get(ColumnMappers.class).findFor(type).map(columnMapper -> new SingleColumnMapper(columnMapper, string)).orElseThrow(() -> new NoSuchMapperException("No column mapper registered for map value " + type + " in column " + string));
    }

    private MapEntryMapper(RowMapper<K> rowMapper, RowMapper<V> rowMapper2) {
        this.keyMapper = rowMapper;
        this.valueMapper = rowMapper2;
    }

    @Override
    public Map.Entry<K, V> map(ResultSet resultSet, StatementContext statementContext) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(this.keyMapper.map(resultSet, statementContext), this.valueMapper.map(resultSet, statementContext));
    }

    @Override
    public RowMapper<Map.Entry<K, V>> specialize(ResultSet resultSet, StatementContext statementContext) {
        return new MapEntryMapper<K, V>(this.keyMapper.specialize(resultSet, statementContext), this.valueMapper.specialize(resultSet, statementContext));
    }

    static {
        TypeVariable<Class<T>>[] typeVariableArray = Map.Entry.class.getTypeParameters();
        KEY_PARAM = typeVariableArray[0];
        VALUE_PARAM = typeVariableArray[1];
    }
}

