/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnGetter;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.GetterMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.OptionalMapper;

class OptionalMapperFactory
implements ColumnMapperFactory {
    private final Map<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    OptionalMapperFactory() {
        this.mappers.put(OptionalInt.class, OptionalMapperFactory.optionalMapper(ResultSet::getInt, OptionalInt::empty, OptionalInt::of));
        this.mappers.put(OptionalLong.class, OptionalMapperFactory.optionalMapper(ResultSet::getLong, OptionalLong::empty, OptionalLong::of));
        this.mappers.put(OptionalDouble.class, OptionalMapperFactory.optionalMapper(ResultSet::getDouble, OptionalDouble::empty, OptionalDouble::of));
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry configRegistry) {
        Class<?> clazz = GenericTypes.getErasedType(type);
        if (clazz == Optional.class) {
            return Optional.of(OptionalMapper.of(type));
        }
        return Optional.ofNullable(this.mappers.get(clazz));
    }

    private static <Opt, Box> ColumnMapper<?> optionalMapper(ColumnGetter<Box> columnGetter, Supplier<Opt> supplier, Function<Box, Opt> function) {
        return (resultSet, n, statementContext) -> Optional.ofNullable(new GetterMapper(columnGetter).map(resultSet, n, statementContext)).map(function).orElseGet(supplier);
    }
}

