/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericType;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.JdbiOptionals;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.InferredRowMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.MapEntryMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapperFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.internal.PojoMapperFactory;

public class RowMappers
implements JdbiConfig<RowMappers> {
    private final List<RowMapperFactory> factories = new CopyOnWriteArrayList<RowMapperFactory>();
    private final ConcurrentHashMap<Type, RowMapper<?>> cache = new ConcurrentHashMap();
    private ConfigRegistry registry;

    public RowMappers() {
        this.register(MapEntryMapper.factory());
        this.register(new PojoMapperFactory());
    }

    private RowMappers(RowMappers rowMappers) {
        this.factories.addAll(rowMappers.factories);
        this.cache.putAll(rowMappers.cache);
    }

    @Override
    public void setRegistry(ConfigRegistry configRegistry) {
        this.registry = configRegistry;
    }

    public RowMappers register(RowMapper<?> rowMapper) {
        return this.register(new InferredRowMapperFactory(rowMapper));
    }

    public <T> RowMappers register(GenericType<T> genericType, RowMapper<T> rowMapper) {
        return this.register(RowMapperFactory.of(genericType.getType(), rowMapper));
    }

    public RowMappers register(Type type, RowMapper<?> rowMapper) {
        return this.register(RowMapperFactory.of(type, rowMapper));
    }

    public RowMappers register(RowMapperFactory rowMapperFactory) {
        this.factories.add(0, rowMapperFactory);
        this.cache.clear();
        return this;
    }

    public <T> Optional<RowMapper<T>> findFor(Class<T> clazz) {
        RowMapper rowMapper = this.findFor((Type)clazz).orElse(null);
        return Optional.ofNullable(rowMapper);
    }

    public <T> Optional<RowMapper<T>> findFor(GenericType<T> genericType) {
        RowMapper rowMapper = this.findFor(genericType.getType()).orElse(null);
        return Optional.ofNullable(rowMapper);
    }

    public Optional<RowMapper<?>> findFor(Type type) {
        RowMapper<?> rowMapper2 = this.cache.get(type);
        if (rowMapper2 != null) {
            return Optional.of(rowMapper2);
        }
        Optional<RowMapper<?>> optional = this.factories.stream().flatMap(rowMapperFactory -> JdbiOptionals.stream(rowMapperFactory.build(type, this.registry))).findFirst();
        optional.ifPresent(rowMapper -> this.cache.put(type, (RowMapper<?>)rowMapper));
        return optional;
    }

    @Override
    public RowMappers createCopy() {
        return new RowMappers(this);
    }
}

