/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.UtilityClassException;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;

public class ReflectionMapperUtil {
    private ReflectionMapperUtil() {
        throw new UtilityClassException();
    }

    public static List<String> getColumnNames(ResultSet resultSet) {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(resultSetMetaData.getColumnLabel(i + 1).toLowerCase());
        }
        return arrayList;
    }

    public static OptionalInt findColumnIndex(String string, List<String> list2, List<ColumnNameMatcher> list3, Supplier<String> supplier) {
        OptionalInt optionalInt = OptionalInt.empty();
        block0: for (int i = 0; i < list2.size(); ++i) {
            String string2 = list2.get(i);
            for (ColumnNameMatcher columnNameMatcher : list3) {
                if (!columnNameMatcher.columnNameMatches(string2, string)) continue;
                if (optionalInt.isPresent()) {
                    throw new IllegalArgumentException(String.format("'%s' (%s) matches multiple columns: '%s' (%d) and '%s' (%d)", supplier.get(), string, list2.get(optionalInt.getAsInt()), optionalInt.getAsInt(), list2.get(i), i));
                }
                optionalInt = OptionalInt.of(i);
                continue block0;
            }
        }
        return optionalInt;
    }

    public static boolean anyColumnsStartWithPrefix(Collection<String> collection, String string, List<ColumnNameMatcher> list2) {
        return collection.stream().anyMatch(string2 -> list2.stream().anyMatch(columnNameMatcher -> columnNameMatcher.columnNameStartsWith((String)string2, string)));
    }
}

