/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.internal;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.glaremasters.guilds.libs.jdbi.v3.core.annotation.Unmappable;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.ColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.Nested;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.NoSuchMapperException;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.SingleColumnMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.ColumnName;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.ReflectionMapperUtil;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.reflect.internal.PojoTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.UnableToProduceResultException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

public class PojoMapper<T>
implements RowMapper<T> {
    private static final String NO_MATCHING_COLUMNS = "Mapping bean %s didn't find any matching columns in result set";
    private static final String UNMATCHED_COLUMNS_STRICT = "Mapping bean %s could not match properties for columns: %s";
    protected boolean strictColumnTypeMapping = true;
    protected final Type type;
    protected final String prefix;
    private final Map<PojoProperties.PojoProperty<T>, PojoMapper<?>> nestedMappers = new ConcurrentHashMap();

    public PojoMapper(Type type, String string) {
        this.type = type;
        this.prefix = string.toLowerCase();
    }

    @Override
    public T map(ResultSet resultSet, StatementContext statementContext) {
        return this.specialize(resultSet, statementContext).map(resultSet, statementContext);
    }

    @Override
    public RowMapper<T> specialize(ResultSet resultSet, StatementContext statementContext) {
        List<String> list2 = ReflectionMapperUtil.getColumnNames(resultSet);
        List<ColumnNameMatcher> list3 = statementContext.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        ArrayList<String> arrayList = new ArrayList<String>(list2);
        RowMapper<T> rowMapper = this.specialize0(statementContext, list2, list3, arrayList).orElseThrow(() -> new IllegalArgumentException(String.format(NO_MATCHING_COLUMNS, this.type)));
        if (statementContext.getConfig(ReflectionMappers.class).isStrictMatching() && ReflectionMapperUtil.anyColumnsStartWithPrefix(arrayList, this.prefix, list3)) {
            throw new IllegalArgumentException(String.format(UNMATCHED_COLUMNS_STRICT, this.type, arrayList));
        }
        return rowMapper;
    }

    private Optional<RowMapper<T>> specialize0(StatementContext statementContext, List<String> list2, List<ColumnNameMatcher> list3, List<String> list4) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (PojoProperties.PojoProperty pojoProperty2 : this.getProperties(statementContext.getConfig()).getProperties().values()) {
            String string;
            Nested nested = pojoProperty2.getAnnotation(Nested.class).orElse(null);
            if (pojoProperty2.getAnnotation(Unmappable.class).map(Unmappable::value).orElse(false).booleanValue()) continue;
            if (nested == null) {
                string = this.prefix + this.getName(pojoProperty2);
                ReflectionMapperUtil.findColumnIndex(string, list2, list3, () -> this.debugName(pojoProperty2)).ifPresent(n -> {
                    ColumnMapper columnMapper = statementContext.findColumnMapperFor(pojoProperty2.getQualifiedType()).orElseGet(() -> this.defaultColumnMapper(pojoProperty2));
                    arrayList.add(new SingleColumnMapper(columnMapper, n + 1));
                    arrayList2.add(pojoProperty2);
                    list4.remove(list2.get(n));
                });
                continue;
            }
            string = this.prefix + nested.value();
            if (!ReflectionMapperUtil.anyColumnsStartWithPrefix(list2, string, list3)) continue;
            this.nestedMappers.computeIfAbsent(pojoProperty2, pojoProperty -> this.createNestedMapper(statementContext, (PojoProperties.PojoProperty<T>)pojoProperty, string)).specialize0(statementContext, list2, list3, list4).ifPresent(rowMapper -> {
                arrayList.add(rowMapper);
                arrayList2.add(pojoProperty2);
            });
        }
        if (arrayList.isEmpty() && !list2.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((resultSet, statementContext2) -> {
            PojoProperties.PojoBuilder<T> pojoBuilder = this.getProperties(statementContext2.getConfig()).create();
            for (int i = 0; i < arrayList.size(); ++i) {
                RowMapper rowMapper = (RowMapper)arrayList.get(i);
                PojoProperties.PojoProperty pojoProperty = (PojoProperties.PojoProperty)arrayList2.get(i);
                Object t = rowMapper.map(resultSet, statementContext);
                pojoBuilder.set(pojoProperty, t);
            }
            return pojoBuilder.build();
        });
    }

    protected PojoProperties<T> getProperties(ConfigRegistry configRegistry) {
        return configRegistry.get(PojoTypes.class).findFor(this.type).orElseThrow(() -> new UnableToProduceResultException("Couldn't find properties for " + this.type));
    }

    protected PojoMapper<?> createNestedMapper(StatementContext statementContext, PojoProperties.PojoProperty<T> pojoProperty, String string) {
        Type type = pojoProperty.getQualifiedType().getType();
        return new PojoMapper<T>(GenericTypes.getErasedType(type), string);
    }

    private ColumnMapper<?> defaultColumnMapper(PojoProperties.PojoProperty<T> pojoProperty) {
        if (this.strictColumnTypeMapping) {
            throw new NoSuchMapperException(String.format("Couldn't find mapper for property '%s' of type '%s' from %s", pojoProperty.getName(), pojoProperty.getQualifiedType(), this.type));
        }
        return (resultSet, n, statementContext) -> resultSet.getObject(n);
    }

    private String getName(PojoProperties.PojoProperty<T> pojoProperty) {
        return pojoProperty.getAnnotation(ColumnName.class).map(ColumnName::value).orElseGet(pojoProperty::getName);
    }

    private String debugName(PojoProperties.PojoProperty<T> pojoProperty) {
        return String.format("%s.%s", this.type, pojoProperty.getName());
    }
}

