/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.qualifier;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericType;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.AnnotationFactory;
import me.glaremasters.guilds.libs.jdbi.v3.meta.Beta;

@Beta
public final class QualifiedType<T> {
    private final Type type;
    private final Set<Annotation> qualifiers;

    public static <T> QualifiedType<T> of(Class<T> clazz) {
        return new QualifiedType<T>(clazz, Collections.emptySet());
    }

    public static QualifiedType<?> of(Type type) {
        return new QualifiedType(type, Collections.emptySet());
    }

    public static <T> QualifiedType<T> of(GenericType<T> genericType) {
        return QualifiedType.of(genericType.getType());
    }

    private QualifiedType(Type type, Set<? extends Annotation> set) {
        this.type = type;
        this.qualifiers = Collections.unmodifiableSet(set);
    }

    public QualifiedType<T> with(Annotation ... annotationArray) {
        return new QualifiedType<T>(this.type, Arrays.stream(annotationArray).collect(Collectors.toSet()));
    }

    @SafeVarargs
    public final QualifiedType<T> with(Class<? extends Annotation> ... classArray) {
        Set set = Arrays.stream(classArray).map(AnnotationFactory::create).collect(Collectors.toSet());
        return new QualifiedType<T>(this.type, set);
    }

    public QualifiedType<T> withAnnotations(Iterable<? extends Annotation> iterable) {
        return new QualifiedType<T>(this.type, StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet()));
    }

    public QualifiedType<T> withAnnotationClasses(Iterable<Class<? extends Annotation>> iterable) {
        Set set = StreamSupport.stream(iterable.spliterator(), false).map(AnnotationFactory::create).collect(Collectors.toSet());
        return new QualifiedType<T>(this.type, set);
    }

    public Type getType() {
        return this.type;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Optional<QualifiedType<?>> mapType(Function<Type, Optional<Type>> function) {
        return function.apply(this.type).map(type -> new QualifiedType<T>((Type)type, this.qualifiers));
    }

    public boolean hasQualifier(Class<? extends Annotation> clazz) {
        return this.qualifiers.stream().anyMatch(clazz::isInstance);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        QualifiedType qualifiedType = (QualifiedType)object;
        return Objects.equals(this.type, qualifiedType.type) && Objects.equals(this.qualifiers, qualifiedType.qualifiers);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.qualifiers);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.qualifiers.forEach(annotation -> stringBuilder.append(annotation).append(" "));
        stringBuilder.append(this.type.getTypeName());
        return stringBuilder.toString();
    }
}

