/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.qualifier;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCache;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCaches;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiConfig;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.Qualifier;
import me.glaremasters.guilds.libs.jdbi.v3.meta.Beta;

@Beta
public class Qualifiers
implements JdbiConfig<Qualifiers> {
    private static final JdbiCache<AnnotatedElement[], Set<Annotation>> QUALIFIER_CACHE = JdbiCaches.declare(annotatedElementArray -> ((AnnotatedElement[])annotatedElementArray).length == 1 ? annotatedElementArray[0] : new HashSet<AnnotatedElement>(Arrays.asList(annotatedElementArray)), Qualifiers::getQualifiers);
    private ConfigRegistry registry;

    @Override
    public void setRegistry(ConfigRegistry configRegistry) {
        this.registry = configRegistry;
    }

    public Set<Annotation> findFor(AnnotatedElement ... annotatedElementArray) {
        if (this.registry == null) {
            return Qualifiers.getQualifiers(annotatedElementArray);
        }
        return QUALIFIER_CACHE.get(annotatedElementArray, this.registry);
    }

    private static Set<Annotation> getQualifiers(AnnotatedElement ... annotatedElementArray) {
        return Collections.unmodifiableSet(Arrays.stream(annotatedElementArray).filter(Objects::nonNull).map(AnnotatedElement::getAnnotations).flatMap(Arrays::stream).filter(annotation -> annotation.annotationType().isAnnotationPresent(Qualifier.class)).collect(Collectors.toSet()));
    }

    @Override
    public Qualifiers createCopy() {
        return this;
    }
}

