/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NamedArgumentFinder;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.JdbiOptionals;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

public class Binding {
    private final Map<Integer, Argument> positionals = new HashMap<Integer, Argument>();
    private final Map<String, Argument> named = new HashMap<String, Argument>();
    private final List<NamedArgumentFinder> namedArgumentFinder = new ArrayList<NamedArgumentFinder>();

    public void addPositional(int n, Argument argument) {
        this.positionals.put(n, argument);
    }

    public void addNamed(String string, Argument argument) {
        this.named.put(string, argument);
    }

    public void addNamedArgumentFinder(NamedArgumentFinder namedArgumentFinder) {
        this.namedArgumentFinder.add(namedArgumentFinder);
    }

    public Optional<Argument> findForName(String string, StatementContext statementContext) {
        if (this.named.containsKey(string)) {
            return Optional.of(this.named.get(string));
        }
        return this.namedArgumentFinder.stream().flatMap(namedArgumentFinder -> JdbiOptionals.stream(namedArgumentFinder.find(string, statementContext))).findFirst();
    }

    public Collection<String> getNames() {
        HashSet<String> hashSet = new HashSet<String>(this.named.keySet());
        this.namedArgumentFinder.forEach(namedArgumentFinder -> hashSet.addAll(namedArgumentFinder.getNames()));
        return Collections.unmodifiableSet(hashSet);
    }

    public Optional<Argument> findForPosition(int n) {
        return Optional.ofNullable(this.positionals.get(n));
    }

    public String toString() {
        String string = this.positionals.entrySet().stream().map(entry -> ((Integer)entry.getKey()).toString() + ':' + entry.getValue()).collect(Collectors.joining(","));
        String string2 = this.named.entrySet().stream().map(entry -> (String)entry.getKey() + ':' + entry.getValue()).collect(Collectors.joining(","));
        String string3 = this.namedArgumentFinder.stream().map(Object::toString).collect(Collectors.joining(","));
        return "{positional:{" + string + "}, named:{" + string2 + "}, finder:[" + string3 + "]}";
    }

    public void clear() {
        this.positionals.clear();
        this.named.clear();
        this.namedArgumentFinder.clear();
    }

    public boolean isEmpty() {
        return this.positionals.isEmpty() && this.named.isEmpty() && this.namedArgumentFinder.isEmpty();
    }
}

