/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCache;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.JdbiCaches;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.lexer.ColonStatementLexer;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.ParsedSql;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlParser;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToCreateStatementException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.internal.ErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Token;

public class ColonPrefixSqlParser
implements SqlParser {
    private static final JdbiCache<String, ParsedSql> PARSED_SQL_CACHE = JdbiCaches.declare(ColonPrefixSqlParser::internalParse);

    @Override
    public ParsedSql parse(String string, StatementContext statementContext) {
        try {
            return PARSED_SQL_CACHE.get(string, statementContext);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnableToCreateStatementException("Exception parsing for named parameter replacement", illegalArgumentException, statementContext);
        }
    }

    @Override
    public String nameParameter(String string, StatementContext statementContext) {
        return ":" + string;
    }

    private static ParsedSql internalParse(String string) {
        ParsedSql.Builder builder = ParsedSql.builder();
        ColonStatementLexer colonStatementLexer = new ColonStatementLexer(CharStreams.fromString(string));
        colonStatementLexer.addErrorListener(new ErrorListener());
        Token token = colonStatementLexer.nextToken();
        while (token.getType() != -1) {
            switch (token.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    builder.append(token.getText());
                    break;
                }
                case 5: {
                    builder.appendNamedParameter(token.getText().substring(1));
                    break;
                }
                case 6: {
                    builder.appendPositionalParameter();
                    break;
                }
                case 4: {
                    builder.append(token.getText().substring(1));
                    break;
                }
            }
            token = colonStatementLexer.nextToken();
        }
        return builder.build();
    }
}

