/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.ParsedParameters;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToExecuteStatementException;

public class ParsedSql {
    static final String POSITIONAL_PARAM = "?";
    private final String sql;
    private final ParsedParameters parameters;

    private ParsedSql(String string, ParsedParameters parsedParameters) {
        this.sql = string;
        this.parameters = parsedParameters;
    }

    public String getSql() {
        return this.sql;
    }

    public ParsedParameters getParameters() {
        return this.parameters;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ParsedSql parsedSql = (ParsedSql)object;
        return Objects.equals(this.sql, parsedSql.sql) && Objects.equals(this.parameters, parsedSql.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.sql, this.parameters);
    }

    public String toString() {
        return "ParsedSql{sql='" + this.sql + '\'' + ", parameters=" + this.parameters + '}';
    }

    public static ParsedSql of(String string, ParsedParameters parsedParameters) {
        return new ParsedSql(string, parsedParameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final StringBuilder sql = new StringBuilder();
        private boolean positional = false;
        private boolean named = false;
        private final List<String> parameterNames = new ArrayList<String>();

        private Builder() {
        }

        public Builder append(String string) {
            this.sql.append(string);
            return this;
        }

        public Builder appendPositionalParameter() {
            this.positional = true;
            this.parameterNames.add(ParsedSql.POSITIONAL_PARAM);
            return this.append(ParsedSql.POSITIONAL_PARAM);
        }

        public Builder appendNamedParameter(String string) {
            this.named = true;
            this.parameterNames.add(string);
            return this.append(ParsedSql.POSITIONAL_PARAM);
        }

        public ParsedSql build() {
            if (this.positional && this.named) {
                throw new UnableToExecuteStatementException("Cannot mix named and positional parameters in a SQL statement: " + this.parameterNames);
            }
            ParsedParameters parsedParameters = new ParsedParameters(this.positional, this.parameterNames);
            return new ParsedSql(this.sql.toString(), parsedParameters);
        }
    }
}

