/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.statement;

import java.sql.SQLException;
import java.time.Instant;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.UtilityClassException;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlLoggable;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.SqlLogger;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;

class SqlLoggerUtil {
    private SqlLoggerUtil() {
        throw new UtilityClassException();
    }

    static <T> T wrap(SqlLoggable<T> sqlLoggable, StatementContext statementContext, SqlLogger sqlLogger) {
        try {
            statementContext.setExecutionMoment(Instant.now());
            sqlLogger.logBeforeExecution(statementContext);
            T t = sqlLoggable.invoke();
            statementContext.setCompletionMoment(Instant.now());
            sqlLogger.logAfterExecution(statementContext);
            return t;
        }
        catch (SQLException sQLException) {
            statementContext.setExceptionMoment(Instant.now());
            sqlLogger.logException(statementContext, sQLException);
            throw sQLException;
        }
    }
}

