/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.DefaultMethodHandler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.Handler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.HandlerFactory;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;

class DefaultMethodHandlerFactory
implements HandlerFactory {
    DefaultMethodHandlerFactory() {
    }

    @Override
    public Optional<Handler> buildHandler(Class<?> clazz3, Method method) {
        if (!method.isDefault()) {
            return Optional.empty();
        }
        Stream.of(method.getAnnotations()).map(Annotation::annotationType).filter(clazz -> clazz.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)).findFirst().ifPresent(clazz2 -> {
            throw new IllegalStateException(String.format("Default method %s.%s has @%s annotation. Statement customizing annotations don't work on default methods.", clazz3.getSimpleName(), method.getName(), clazz2.getSimpleName()));
        });
        for (Parameter parameter : method.getParameters()) {
            Stream.of(parameter.getAnnotations()).map(Annotation::annotationType).filter(clazz -> clazz.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)).findFirst().ifPresent(clazz2 -> {
                throw new IllegalStateException(String.format("Default method %s.%s parameter %s has @%s annotation. Statement customizing annotations don't work on default methods.", clazz3.getSimpleName(), method.getName(), parameter.getName(), clazz2.getSimpleName()));
            });
        }
        return Optional.of(new DefaultMethodHandler(method));
    }
}

