/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.DecoratorOrder;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.Handler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.HandlerDecorator;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.SqlMethodDecoratingAnnotation;

class SqlMethodAnnotatedHandlerDecorator
implements HandlerDecorator {
    SqlMethodAnnotatedHandlerDecorator() {
    }

    @Override
    public Handler decorateHandler(Handler handler, Class<?> clazz2, Method method) {
        Handler handler2 = handler;
        List list2 = Stream.of(method.getAnnotations()).map(Annotation::annotationType).filter(clazz -> clazz.isAnnotationPresent(SqlMethodDecoratingAnnotation.class)).collect(Collectors.toList());
        Stream.of(method, clazz2).map(genericDeclaration -> genericDeclaration.getAnnotation(DecoratorOrder.class)).filter(Objects::nonNull).findFirst().ifPresent(decoratorOrder -> list2.sort(this.createDecoratorComparator((DecoratorOrder)decoratorOrder).reversed()));
        List list3 = list2.stream().map(clazz -> clazz.getAnnotation(SqlMethodDecoratingAnnotation.class)).map(sqlMethodDecoratingAnnotation -> SqlMethodAnnotatedHandlerDecorator.buildDecorator(sqlMethodDecoratingAnnotation.value())).collect(Collectors.toList());
        for (HandlerDecorator handlerDecorator : list3) {
            handler2 = handlerDecorator.decorateHandler(handler2, clazz2, method);
        }
        return handler2;
    }

    private Comparator<Class<? extends Annotation>> createDecoratorComparator(DecoratorOrder decoratorOrder) {
        List<Class<? extends Annotation>> list2 = Arrays.asList(decoratorOrder.value());
        return Comparator.comparingInt(clazz -> {
            int n = list2.indexOf(clazz);
            return n == -1 ? list2.size() : n;
        });
    }

    private static HandlerDecorator buildDecorator(Class<? extends HandlerDecorator> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IllegalStateException("Decorator class " + clazz + "cannot be instantiated", reflectiveOperationException);
        }
    }
}

