/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.ExtensionFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.ExtensionMethod;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.HandleSupplier;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.Handler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.HandlerDecorators;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.Handlers;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.SqlObject;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.SqlOperation;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.config.Configurer;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

public class SqlObjectFactory
implements ExtensionFactory {
    private static final Object[] NO_ARGS = new Object[0];
    private final Map<Class<?>, Map<Method, Handler>> handlersCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Class<? extends Configurer>, Configurer> configurers = Collections.synchronizedMap(new WeakHashMap());

    SqlObjectFactory() {
    }

    @Override
    public boolean accepts(Class<?> clazz) {
        if (this.looksLikeSqlObject(clazz)) {
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException("SQL Objects are only supported for interfaces.");
            }
            return true;
        }
        return false;
    }

    private boolean looksLikeSqlObject(Class<?> clazz) {
        if (SqlObject.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Stream.of(clazz.getMethods()).flatMap(method -> Stream.of(method.getAnnotations())).anyMatch(annotation -> annotation.annotationType().isAnnotationPresent(SqlOperation.class));
    }

    @Override
    public <E> E attach(Class<E> clazz, HandleSupplier handleSupplier) {
        Map<Method, Handler> map = this.methodHandlersFor(clazz, handleSupplier.getConfig(Handlers.class), handleSupplier.getConfig(HandlerDecorators.class));
        ConfigRegistry configRegistry = handleSupplier.getConfig().createCopy();
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.forEachConfigurer(clazz2, (configurer, annotation) -> configurer.configureForType(configRegistry, (Annotation)annotation, clazz));
        }
        this.forEachConfigurer(clazz, (configurer, annotation) -> configurer.configureForType(configRegistry, (Annotation)annotation, clazz));
        InvocationHandler invocationHandler = this.createInvocationHandler(clazz, configRegistry, map, handleSupplier);
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler));
    }

    private Map<Method, Handler> methodHandlersFor(Class<?> clazz, Handlers handlers, HandlerDecorators handlerDecorators) {
        return this.handlersCache.computeIfAbsent(clazz, clazz2 -> {
            HashMap<Method, Handler> hashMap = new HashMap<Method, Handler>();
            hashMap.putAll(SqlObjectFactory.handlerEntry((object, objectArray, handleSupplier) -> clazz.getName() + '@' + Integer.toHexString(object.hashCode()), Object.class, "toString", new Class[0]));
            hashMap.putAll(SqlObjectFactory.handlerEntry((object, objectArray, handleSupplier) -> object == objectArray[0], Object.class, "equals", Object.class));
            hashMap.putAll(SqlObjectFactory.handlerEntry((object, objectArray, handleSupplier) -> System.identityHashCode(object), Object.class, "hashCode", new Class[0]));
            hashMap.putAll(SqlObjectFactory.handlerEntry((object, objectArray, handleSupplier) -> handleSupplier.getHandle(), SqlObject.class, "getHandle", new Class[0]));
            try {
                hashMap.putAll(SqlObjectFactory.handlerEntry((object, objectArray, handleSupplier) -> null, clazz, "finalize", new Class[0]));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            for (Method method2 : clazz.getMethods()) {
                if (Modifier.isStatic(method2.getModifiers())) continue;
                hashMap.computeIfAbsent(method2, method -> this.buildMethodHandler(clazz, (Method)method, handlers, handlerDecorators));
            }
            hashMap.keySet().stream().filter(method -> !method.isSynthetic()).collect(Collectors.groupingBy(method -> Arrays.asList(method.getName(), Arrays.asList(method.getParameterTypes())))).values().stream().filter(list2 -> list2.size() > 1).findAny().ifPresent(list2 -> {
                throw new UnableToCreateSqlObjectException(clazz + " has ambiguous methods " + list2 + ", please resolve with an explicit override");
            });
            return hashMap;
        });
    }

    private Handler buildMethodHandler(Class<?> clazz, Method method, Handlers handlers, HandlerDecorators handlerDecorators) {
        Handler handler = handlers.findFor(clazz, method).orElseThrow(() -> new IllegalStateException(String.format("Method %s.%s must be default or be annotated with a SQL method annotation.", clazz.getSimpleName(), method.getName())));
        return handlerDecorators.applyDecorators(handler, clazz, method);
    }

    private static Map<Method, Handler> handlerEntry(Handler handler, Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return Collections.singletonMap(clazz.getMethod(string, classArray), handler);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new IllegalStateException(String.format("can't find %s#%s%s", clazz.getName(), string, Arrays.asList(classArray)), exception);
        }
    }

    private InvocationHandler createInvocationHandler(Class<?> clazz, ConfigRegistry configRegistry, Map<Method, Handler> map, HandleSupplier handleSupplier) {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        Function<Method, ConfigRegistry> function = method -> {
            ConfigRegistry configRegistry2 = configRegistry.createCopy();
            this.forEachConfigurer((AnnotatedElement)method, (configurer, annotation) -> configurer.configureForMethod(configRegistry2, (Annotation)annotation, clazz, (Method)method));
            return configRegistry2;
        };
        return (object, method, objectArray) -> {
            ConfigRegistry configRegistry = ((ConfigRegistry)concurrentHashMap.computeIfAbsent(method, function)).createCopy();
            Handler handler = (Handler)map.get(method);
            return handleSupplier.invokeInContext(new ExtensionMethod(clazz, method), configRegistry, () -> handler.invoke(object, objectArray == null ? NO_ARGS : objectArray, handleSupplier));
        };
    }

    private void forEachConfigurer(AnnotatedElement annotatedElement, BiConsumer<Configurer, Annotation> biConsumer) {
        Stream.of(annotatedElement.getAnnotations()).filter(annotation -> annotation.annotationType().isAnnotationPresent(ConfiguringAnnotation.class)).forEach(annotation -> {
            ConfiguringAnnotation configuringAnnotation = annotation.annotationType().getAnnotation(ConfiguringAnnotation.class);
            biConsumer.accept(this.getConfigurer(configuringAnnotation.value()), (Annotation)annotation);
        });
    }

    private Configurer getConfigurer(Class<? extends Configurer> clazz) {
        return this.configurers.computeIfAbsent(clazz, clazz2 -> {
            try {
                return (Configurer)clazz2.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new IllegalStateException("Unable to instantiate configurer factory class " + clazz, reflectiveOperationException);
            }
        });
    }
}

