/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.Qualifiers;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultIterable;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultIterator;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.SingleValue;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

abstract class ResultReturner {
    ResultReturner() {
    }

    static ResultReturner forOptionalReturn(Class<?> clazz, Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return new VoidReturner();
        }
        return ResultReturner.forMethod(clazz, method);
    }

    static ResultReturner forMethod(Class<?> clazz, Method method) {
        Type type = GenericTypes.resolveType(method.getGenericReturnType(), clazz);
        QualifiedType<?> qualifiedType = QualifiedType.of(type).withAnnotations(new Qualifiers().findFor(method));
        Class<?> clazz2 = GenericTypes.getErasedType(type);
        if (Void.TYPE.equals(clazz2)) {
            return ResultReturner.findConsumer(method).orElseThrow(() -> new IllegalStateException(String.format("Method %s#%s is annotated as if it should return a value, but the method is void.", method.getDeclaringClass().getName(), method.getName())));
        }
        if (ResultIterable.class.equals(clazz2)) {
            return new ResultIterableReturner(qualifiedType);
        }
        if (Stream.class.equals(clazz2)) {
            return new StreamReturner(qualifiedType);
        }
        if (ResultIterator.class.equals(clazz2)) {
            return new ResultIteratorReturner(qualifiedType);
        }
        if (Iterator.class.equals(clazz2)) {
            return new IteratorReturner(qualifiedType);
        }
        if (method.isAnnotationPresent(SingleValue.class)) {
            return new SingleValueReturner(qualifiedType);
        }
        return new CollectedResultReturner(qualifiedType);
    }

    static Optional<ResultReturner> findConsumer(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != Consumer.class) continue;
            return Optional.of(new ConsumerResultReturner(method, i));
        }
        return Optional.empty();
    }

    protected abstract Object mappedResult(ResultIterable<?> var1, StatementContext var2);

    protected abstract Object reducedResult(Stream<?> var1, StatementContext var2);

    protected abstract QualifiedType<?> elementType(StatementContext var1);

    private static Object checkResult(Object object, QualifiedType<?> qualifiedType) {
        if (object == null && GenericTypes.getErasedType(qualifiedType.getType()).isPrimitive()) {
            throw new IllegalStateException("SQL method returns primitive " + qualifiedType + ", but statement returned no results");
        }
        return object;
    }

    static class ConsumerResultReturner
    extends ResultReturner {
        private final int consumerIndex;
        private final QualifiedType<?> elementType;

        ConsumerResultReturner(Method method, int n) {
            this.consumerIndex = n;
            Type type = method.getGenericParameterTypes()[n];
            this.elementType = QualifiedType.of(GenericTypes.findGenericParameter(type, Consumer.class).orElseThrow(() -> new IllegalStateException("Cannot reflect Consumer<T> element type T in method consumer parameter " + type))).withAnnotations(new Qualifiers().findFor(method.getParameters()[n]));
        }

        @Override
        protected Void mappedResult(ResultIterable<?> resultIterable, StatementContext statementContext) {
            Consumer consumer = (Consumer)statementContext.getConfig(SqlObjectStatementConfiguration.class).getArgs()[this.consumerIndex];
            resultIterable.forEach(consumer);
            return null;
        }

        @Override
        protected Void reducedResult(Stream<?> stream, StatementContext statementContext) {
            Consumer consumer = (Consumer)statementContext.getConfig(SqlObjectStatementConfiguration.class).getArgs()[this.consumerIndex];
            stream.forEach(consumer);
            return null;
        }

        @Override
        protected QualifiedType<?> elementType(StatementContext statementContext) {
            return this.elementType;
        }
    }

    static class CollectedResultReturner<T>
    extends ResultReturner {
        private final QualifiedType<T> returnType;

        CollectedResultReturner(QualifiedType<T> qualifiedType) {
            this.returnType = qualifiedType;
        }

        @Override
        protected Object mappedResult(ResultIterable<?> resultIterable, StatementContext statementContext) {
            Collector collector = statementContext.findCollectorFor(this.returnType.getType()).orElse(null);
            if (collector != null) {
                return resultIterable.collect(collector);
            }
            return ResultReturner.checkResult(resultIterable.findFirst().orElse(null), this.returnType);
        }

        @Override
        protected Object reducedResult(Stream<?> stream, StatementContext statementContext) {
            Collector collector = statementContext.findCollectorFor(this.returnType.getType()).orElse(null);
            if (collector != null) {
                return stream.collect(collector);
            }
            return ResultReturner.checkResult(stream.findFirst().orElse(null), this.returnType);
        }

        @Override
        protected QualifiedType<?> elementType(StatementContext statementContext) {
            return this.returnType.mapType(type -> statementContext.findElementTypeFor((Type)type)).orElse(this.returnType);
        }
    }

    static class SingleValueReturner<T>
    extends ResultReturner {
        private final QualifiedType<T> returnType;

        SingleValueReturner(QualifiedType<T> qualifiedType) {
            this.returnType = qualifiedType;
        }

        @Override
        protected Object mappedResult(ResultIterable<?> resultIterable, StatementContext statementContext) {
            return ResultReturner.checkResult(resultIterable.findFirst().orElse(null), this.returnType);
        }

        @Override
        protected Object reducedResult(Stream<?> stream, StatementContext statementContext) {
            return ResultReturner.checkResult(stream.findFirst().orElse(null), this.returnType);
        }

        protected QualifiedType<T> elementType(StatementContext statementContext) {
            return this.returnType;
        }
    }

    static class IteratorReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        IteratorReturner(QualifiedType<?> qualifiedType) {
            this.elementType = qualifiedType.mapType(type -> GenericTypes.findGenericParameter(type, Iterator.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect Iterator<T> element type T in method return type " + qualifiedType));
        }

        @Override
        protected Iterator<?> mappedResult(ResultIterable<?> resultIterable, StatementContext statementContext) {
            return resultIterable.iterator();
        }

        @Override
        protected Iterator<?> reducedResult(Stream<?> stream, StatementContext statementContext) {
            return stream.iterator();
        }

        @Override
        protected QualifiedType<?> elementType(StatementContext statementContext) {
            return this.elementType;
        }
    }

    static class ResultIteratorReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        ResultIteratorReturner(QualifiedType<?> qualifiedType) {
            this.elementType = qualifiedType.mapType(type -> GenericTypes.findGenericParameter(type, Iterator.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect ResultIterator<T> element type T in method return type " + qualifiedType));
        }

        @Override
        protected ResultIterator<?> mappedResult(ResultIterable<?> resultIterable, StatementContext statementContext) {
            return resultIterable.iterator();
        }

        @Override
        protected ResultIterator<?> reducedResult(Stream<?> stream, StatementContext statementContext) {
            throw new UnsupportedOperationException("Cannot return ResultIterator from a @UseRowReducer method");
        }

        @Override
        protected QualifiedType<?> elementType(StatementContext statementContext) {
            return this.elementType;
        }
    }

    static class StreamReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        StreamReturner(QualifiedType<?> qualifiedType) {
            this.elementType = qualifiedType.mapType(type -> GenericTypes.findGenericParameter(type, Stream.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect Stream<T> element type T in method return type " + qualifiedType));
        }

        @Override
        protected Stream<?> mappedResult(ResultIterable<?> resultIterable, StatementContext statementContext) {
            return resultIterable.stream();
        }

        @Override
        protected Stream<?> reducedResult(Stream<?> stream, StatementContext statementContext) {
            return stream;
        }

        @Override
        protected QualifiedType<?> elementType(StatementContext statementContext) {
            return this.elementType;
        }
    }

    static class ResultIterableReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        ResultIterableReturner(QualifiedType<?> qualifiedType) {
            this.elementType = qualifiedType.mapType(type -> GenericTypes.findGenericParameter(type, ResultIterable.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect ResultIterable<T> element type T in method return type " + qualifiedType));
        }

        @Override
        protected ResultIterable<?> mappedResult(ResultIterable<?> resultIterable, StatementContext statementContext) {
            return resultIterable;
        }

        @Override
        protected ResultIterator<?> reducedResult(Stream<?> stream, StatementContext statementContext) {
            throw new UnsupportedOperationException("Cannot return ResultIterable from a @UseRowReducer method");
        }

        @Override
        protected QualifiedType<?> elementType(StatementContext statementContext) {
            return this.elementType;
        }
    }

    static class VoidReturner
    extends ResultReturner {
        VoidReturner() {
        }

        @Override
        protected Void mappedResult(ResultIterable<?> resultIterable, StatementContext statementContext) {
            resultIterable.stream().forEach(object -> {});
            return null;
        }

        @Override
        protected Void reducedResult(Stream<?> stream, StatementContext statementContext) {
            throw new UnsupportedOperationException("Cannot return void from a @UseRowReducer method");
        }

        @Override
        protected QualifiedType<?> elementType(StatementContext statementContext) {
            return null;
        }
    }
}

