/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.extension.HandleSupplier;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.internal.IterableLike;
import me.glaremasters.guilds.libs.jdbi.v3.core.mapper.RowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultIterable;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultIterator;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.PreparedBatch;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.StatementContext;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.UnableToCreateStatementException;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.SingleValue;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.BatchChunkSize;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.SqlBatch;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.UseRowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.UseRowReducer;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.CustomizingStatementHandler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.ResultReturner;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class SqlBatchHandler
extends CustomizingStatementHandler<PreparedBatch> {
    private final SqlBatch sqlBatch;
    private final ChunkSizeFunction batchChunkSize;
    private final Function<PreparedBatch, ResultIterator<?>> batchIntermediate;
    private final ResultReturner magic;

    public SqlBatchHandler(Class<?> clazz, Method method) {
        super(clazz, method);
        if (method.isAnnotationPresent(UseRowReducer.class)) {
            throw new UnsupportedOperationException("Cannot declare @UseRowReducer on a @SqlUpdate method.");
        }
        this.sqlBatch = method.getAnnotation(SqlBatch.class);
        this.batchChunkSize = this.determineBatchChunkSize(clazz, method);
        GetGeneratedKeys getGeneratedKeys = method.getAnnotation(GetGeneratedKeys.class);
        if (getGeneratedKeys == null) {
            if (!SqlBatchHandler.returnTypeIsValid(method.getReturnType())) {
                throw new UnableToCreateSqlObjectException(SqlBatchHandler.invalidReturnTypeMessage(method));
            }
            Function<PreparedBatch, ResultIterator<?>> function = PreparedBatch::executeAndGetModCount;
            this.batchIntermediate = method.getReturnType().equals(boolean[].class) ? this.mapToBoolean(function) : function;
            this.magic = ResultReturner.forOptionalReturn(clazz, method);
        } else {
            String[] stringArray = getGeneratedKeys.value();
            this.magic = ResultReturner.forMethod(clazz, method);
            if (method.isAnnotationPresent(UseRowMapper.class)) {
                RowMapper<?> rowMapper = SqlBatchHandler.rowMapperFor(method.getAnnotation(UseRowMapper.class));
                this.batchIntermediate = preparedBatch -> preparedBatch.executeAndReturnGeneratedKeys(stringArray).map(rowMapper).iterator();
            } else {
                this.batchIntermediate = preparedBatch -> preparedBatch.executeAndReturnGeneratedKeys(stringArray).mapTo(this.magic.elementType(preparedBatch.getContext())).iterator();
            }
        }
    }

    private Function<PreparedBatch, ResultIterator<?>> mapToBoolean(Function<PreparedBatch, ResultIterator<?>> function) {
        return function.andThen(resultIterator -> new ResultIterator<Boolean>(){

            @Override
            public boolean hasNext() {
                return resultIterator.hasNext();
            }

            @Override
            public Boolean next() {
                return (Integer)resultIterator.next() > 0;
            }

            @Override
            public void close() {
                resultIterator.close();
            }

            @Override
            public StatementContext getContext() {
                return resultIterator.getContext();
            }
        });
    }

    private ChunkSizeFunction determineBatchChunkSize(Class<?> clazz, Method method) {
        int n = this.indexOfBatchChunkSizeParameter(method);
        if (n >= 0) {
            return new ParamBasedChunkSizeFunction(n);
        }
        if (method.isAnnotationPresent(BatchChunkSize.class)) {
            int n2 = method.getAnnotation(BatchChunkSize.class).value();
            if (n2 <= 0) {
                throw new IllegalArgumentException("Batch chunk size must be >= 0");
            }
            return new ConstantChunkSizeFunction(n2);
        }
        if (clazz.isAnnotationPresent(BatchChunkSize.class)) {
            int n3 = clazz.getAnnotation(BatchChunkSize.class).value();
            return new ConstantChunkSizeFunction(n3);
        }
        return new ConstantChunkSizeFunction(Integer.MAX_VALUE);
    }

    private int indexOfBatchChunkSizeParameter(Method method) {
        Annotation[][] annotationArray = method.getParameterAnnotations();
        return IntStream.range(0, annotationArray.length).filter(n -> Stream.of(annotationArray[n]).anyMatch(BatchChunkSize.class::isInstance)).findFirst().orElse(-1);
    }

    @Override
    PreparedBatch createStatement(Handle handle, String string) {
        return handle.prepareBatch(string);
    }

    @Override
    void configureReturner(PreparedBatch preparedBatch, SqlObjectStatementConfiguration sqlObjectStatementConfiguration) {
    }

    @Override
    Type getParameterType(Parameter parameter) {
        Type type = super.getParameterType(parameter);
        if (!parameter.isAnnotationPresent(SingleValue.class)) {
            Class<?> clazz = GenericTypes.getErasedType(type);
            if (Iterable.class.isAssignableFrom(clazz)) {
                return GenericTypes.findGenericParameter(type, Iterable.class).get();
            }
            if (Iterator.class.isAssignableFrom(clazz)) {
                return GenericTypes.findGenericParameter(type, Iterator.class).get();
            }
            if (GenericTypes.isArray(type)) {
                return ((Class)type).getComponentType();
            }
        }
        return type;
    }

    @Override
    public Object invoke(Object object, Object[] objectArray, HandleSupplier handleSupplier) {
        Object object2;
        ResultIterator<Object> resultIterator;
        final Handle handle = handleSupplier.getHandle();
        final String string = this.locateSql(handle);
        final int n = this.batchChunkSize.call(objectArray);
        final Iterator<Object[]> iterator = this.zipArgs(this.getMethod(), objectArray);
        if (iterator.hasNext()) {
            resultIterator = new ResultIterator<Object>(){
                private ResultIterator<?> batchResult;
                private boolean closed = false;

                @Override
                public boolean hasNext() {
                    if (this.closed) {
                        throw new IllegalStateException("closed");
                    }
                    if (this.batchResult != null) {
                        if (this.batchResult.hasNext()) {
                            return true;
                        }
                        this.batchResult.close();
                    }
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    PreparedBatch preparedBatch = handle.prepareBatch(string);
                    for (int i = 0; i < n && iterator.hasNext(); ++i) {
                        SqlBatchHandler.this.applyCustomizers(preparedBatch, (Object[])iterator.next());
                        preparedBatch.add();
                    }
                    this.batchResult = SqlBatchHandler.this.executeBatch(handle, preparedBatch);
                    return this.hasNext();
                }

                @Override
                public Object next() {
                    if (this.closed) {
                        throw new IllegalStateException("closed");
                    }
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.batchResult.next();
                }

                @Override
                public StatementContext getContext() {
                    return this.batchResult.getContext();
                }

                @Override
                public void close() {
                    this.closed = true;
                    this.batchResult.close();
                }
            };
            resultIterator.hasNext();
        } else {
            object2 = handle.prepareBatch(string);
            resultIterator = new ResultIterator<Object>((PreparedBatch)object2){
                final /* synthetic */ PreparedBatch val$dummy;
                {
                    this.val$dummy = preparedBatch;
                }

                @Override
                public void close() {
                }

                @Override
                public StatementContext getContext() {
                    return this.val$dummy.getContext();
                }

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Object next() {
                    throw new NoSuchElementException();
                }
            };
        }
        object2 = ResultIterable.of(resultIterator);
        return this.magic.mappedResult((ResultIterable<?>)object2, resultIterator.getContext());
    }

    private Iterator<Object[]> zipArgs(Method method, Object[] objectArray) {
        boolean bl = false;
        final ArrayList<Iterator<Object>> arrayList = new ArrayList<Iterator<Object>>();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            boolean bl2 = method.getParameters()[i].isAnnotationPresent(SingleValue.class);
            Object object = objectArray[i];
            if (!bl2 && IterableLike.isIterable(object)) {
                arrayList.add(IterableLike.of(object));
                bl = true;
                continue;
            }
            arrayList.add(Stream.generate(() -> object).iterator());
        }
        if (!bl) {
            throw new UnableToCreateStatementException("@SqlBatch method has no Iterable or array parameters, did you mean @SqlQuery?", null, null);
        }
        final Object[] objectArray2 = new Object[objectArray.length];
        return new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                for (Iterator iterator : arrayList) {
                    if (iterator.hasNext()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Object[] next() {
                for (int i = 0; i < arrayList.size(); ++i) {
                    objectArray2[i] = ((Iterator)arrayList.get(i)).next();
                }
                return objectArray2;
            }
        };
    }

    private ResultIterator<?> executeBatch(Handle handle2, PreparedBatch preparedBatch) {
        if (!handle2.isInTransaction() && this.sqlBatch.transactional()) {
            return handle2.inTransaction(handle -> this.batchIntermediate.apply(preparedBatch));
        }
        return this.batchIntermediate.apply(preparedBatch);
    }

    private static boolean returnTypeIsValid(Class<?> clazz) {
        if (clazz.equals(Void.TYPE)) {
            return true;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            return clazz2.equals(Integer.TYPE) || clazz2.equals(Boolean.TYPE);
        }
        return false;
    }

    private static String invalidReturnTypeMessage(Method method) {
        return method.getDeclaringClass() + "." + method.getName() + " method is annotated with @SqlBatch so should return void, int[], or boolean[] but is returning: " + method.getReturnType();
    }

    private static class ParamBasedChunkSizeFunction
    implements ChunkSizeFunction {
        private final int index;

        ParamBasedChunkSizeFunction(int n) {
            this.index = n;
        }

        @Override
        public int call(Object[] objectArray) {
            return (Integer)objectArray[this.index];
        }
    }

    private static class ConstantChunkSizeFunction
    implements ChunkSizeFunction {
        private final int value;

        ConstantChunkSizeFunction(int n) {
            this.value = n;
        }

        @Override
        public int call(Object[] objectArray) {
            return this.value;
        }
    }

    private static interface ChunkSizeFunction {
        public int call(Object[] var1);
    }
}

