/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.Method;
import java.util.function.Function;
import me.glaremasters.guilds.libs.jdbi.v3.core.Handle;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.QualifiedType;
import me.glaremasters.guilds.libs.jdbi.v3.core.qualifier.Qualifiers;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultBearing;
import me.glaremasters.guilds.libs.jdbi.v3.core.result.ResultIterable;
import me.glaremasters.guilds.libs.jdbi.v3.core.statement.Update;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.UseRowMapper;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.UseRowReducer;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.CustomizingStatementHandler;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.ResultReturner;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class SqlUpdateHandler
extends CustomizingStatementHandler<Update> {
    private final Function<Update, Object> returner;

    public SqlUpdateHandler(Class<?> clazz, Method method) {
        super(clazz, method);
        if (method.isAnnotationPresent(UseRowReducer.class)) {
            throw new UnsupportedOperationException("Cannot declare @UseRowReducer on a @SqlUpdate method.");
        }
        boolean bl = method.isAnnotationPresent(GetGeneratedKeys.class);
        QualifiedType<?> qualifiedType = QualifiedType.of(GenericTypes.resolveType(method.getGenericReturnType(), clazz)).withAnnotations(new Qualifiers().findFor(method));
        if (bl) {
            ResultReturner resultReturner = ResultReturner.forMethod(clazz, method);
            String[] stringArray = method.getAnnotation(GetGeneratedKeys.class).value();
            this.returner = update -> {
                ResultBearing resultBearing = update.executeAndReturnGeneratedKeys(stringArray);
                UseRowMapper useRowMapper = method.getAnnotation(UseRowMapper.class);
                ResultIterable<Object> resultIterable = useRowMapper == null ? resultBearing.mapTo(qualifiedType) : resultBearing.map(SqlUpdateHandler.rowMapperFor(useRowMapper));
                return resultReturner.mappedResult(resultIterable, update.getContext());
            };
        } else if (this.isNumeric(method.getReturnType())) {
            this.returner = update -> update.execute();
        } else if (this.isBoolean(method.getReturnType())) {
            this.returner = update -> update.execute() > 0;
        } else {
            throw new UnableToCreateSqlObjectException(this.invalidReturnTypeMessage(method, qualifiedType));
        }
    }

    @Override
    Update createStatement(Handle handle, String string) {
        return handle.createUpdate(string);
    }

    @Override
    void configureReturner(Update update, SqlObjectStatementConfiguration sqlObjectStatementConfiguration) {
        sqlObjectStatementConfiguration.setReturner(() -> this.returner.apply(update));
    }

    private boolean isNumeric(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz) || clazz.equals(Integer.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Void.TYPE);
    }

    private boolean isBoolean(Class<?> clazz) {
        return clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class);
    }

    private String invalidReturnTypeMessage(Method method, QualifiedType<?> qualifiedType) {
        return method.getDeclaringClass().getSimpleName() + "." + method.getName() + " method is annotated with @SqlUpdate so should return void, boolean, or Number but is returning: " + qualifiedType;
    }
}

