/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.kyori.adventure.platform.bukkit;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import me.glaremasters.guilds.libs.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import me.glaremasters.guilds.libs.kyori.adventure.platform.bukkit.MinecraftReflection;
import me.glaremasters.guilds.libs.kyori.adventure.text.Component;
import me.glaremasters.guilds.libs.kyori.adventure.text.serializer.ComponentSerializer;
import me.glaremasters.guilds.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class MinecraftComponentSerializer
implements ComponentSerializer<Component, Component, Object> {
    private static final MinecraftComponentSerializer INSTANCE = new MinecraftComponentSerializer();
    @Nullable
    private static final Class<?> CLASS_JSON_DESERIALIZER = MinecraftReflection.findClass("com.goo".concat("gle.gson.JsonDeserializer"));
    @Nullable
    private static final Class<?> CLASS_CHAT_COMPONENT = MinecraftReflection.findClass(MinecraftReflection.findNmsClassName("IChatBaseComponent"), MinecraftReflection.findMcClassName("network.chat.IChatBaseComponent"), MinecraftReflection.findMcClassName("network.chat.Component"));
    private static final AtomicReference<RuntimeException> INITIALIZATION_ERROR = new AtomicReference<UnsupportedOperationException>(new UnsupportedOperationException());
    private static final Object MC_TEXT_GSON;
    private static final MethodHandle TEXT_SERIALIZER_DESERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE;
    private static final boolean SUPPORTED;

    public static boolean isSupported() {
        return SUPPORTED;
    }

    @NotNull
    public static MinecraftComponentSerializer get() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull Object object) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        try {
            if (MC_TEXT_GSON != null) {
                JsonElement jsonElement = ((Gson)MC_TEXT_GSON).toJsonTree(object);
                return BukkitComponentSerializer.gson().serializer().fromJson(jsonElement, Component.class);
            }
            return GsonComponentSerializer.gson().deserialize(TEXT_SERIALIZER_SERIALIZE.invoke(object));
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
    }

    @Override
    @NotNull
    public Object serialize(@NotNull Component component) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        if (MC_TEXT_GSON != null) {
            JsonElement jsonElement = BukkitComponentSerializer.gson().serializer().toJsonTree(component);
            try {
                return ((Gson)MC_TEXT_GSON).fromJson(jsonElement, CLASS_CHAT_COMPONENT);
            }
            catch (Throwable throwable) {
                throw new UnsupportedOperationException(throwable);
            }
        }
        try {
            return TEXT_SERIALIZER_DESERIALIZE.invoke((String)BukkitComponentSerializer.gson().serialize(component));
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
    }

    static {
        Object object = null;
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        try {
            Class<?> clazz2;
            if (CLASS_CHAT_COMPONENT != null && (clazz2 = Arrays.stream(CLASS_CHAT_COMPONENT.getClasses()).filter(clazz -> {
                if (CLASS_JSON_DESERIALIZER != null) {
                    return CLASS_JSON_DESERIALIZER.isAssignableFrom((Class<?>)clazz);
                }
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    if (!clazz2.getSimpleName().equals("JsonDeserializer")) continue;
                    return true;
                }
                return false;
            }).findAny().orElse(MinecraftReflection.findNmsClass("ChatSerializer"))) != null) {
                Field field2 = Arrays.stream(clazz2.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType().equals(Gson.class)).findFirst().orElse(null);
                if (field2 != null) {
                    field2.setAccessible(true);
                    object = field2.get(null);
                } else {
                    Method[] methodArray = clazz2.getDeclaredMethods();
                    Method method2 = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> CLASS_CHAT_COMPONENT.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(String.class)).min(Comparator.comparing(Method::getName)).orElse(null);
                    Method method3 = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(String.class)).filter(method -> method.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(method.getParameterTypes()[0])).findFirst().orElse(null);
                    if (method2 != null) {
                        methodHandle = MinecraftReflection.lookup().unreflect(method2);
                    }
                    if (method3 != null) {
                        methodHandle2 = MinecraftReflection.lookup().unreflect(method3);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            INITIALIZATION_ERROR.set(new UnsupportedOperationException("Error occurred during initialization", throwable));
        }
        MC_TEXT_GSON = object;
        TEXT_SERIALIZER_DESERIALIZE = methodHandle;
        TEXT_SERIALIZER_SERIALIZE = methodHandle2;
        SUPPORTED = MC_TEXT_GSON != null || TEXT_SERIALIZER_DESERIALIZE != null && TEXT_SERIALIZER_SERIALIZE != null;
    }
}

