/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.app.builder;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import me.glaremasters.guilds.libs.slimjar.app.Application;
import me.glaremasters.guilds.libs.slimjar.app.builder.InjectingApplicationBuilder;
import me.glaremasters.guilds.libs.slimjar.app.builder.IsolatedApplicationBuilder;
import me.glaremasters.guilds.libs.slimjar.app.builder.IsolationConfiguration;
import me.glaremasters.guilds.libs.slimjar.downloader.DependencyDownloaderFactory;
import me.glaremasters.guilds.libs.slimjar.downloader.URLDependencyDownloaderFactory;
import me.glaremasters.guilds.libs.slimjar.downloader.output.DependencyOutputWriterFactory;
import me.glaremasters.guilds.libs.slimjar.downloader.strategy.ChecksumFilePathStrategy;
import me.glaremasters.guilds.libs.slimjar.downloader.strategy.FilePathStrategy;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.ChecksumDependencyVerifierFactory;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.DependencyVerifierFactory;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.FileChecksumCalculator;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.PassthroughDependencyVerifierFactory;
import me.glaremasters.guilds.libs.slimjar.injector.DependencyInjector;
import me.glaremasters.guilds.libs.slimjar.injector.DependencyInjectorFactory;
import me.glaremasters.guilds.libs.slimjar.injector.SimpleDependencyInjectorFactory;
import me.glaremasters.guilds.libs.slimjar.injector.helper.InjectionHelperFactory;
import me.glaremasters.guilds.libs.slimjar.injector.loader.Injectable;
import me.glaremasters.guilds.libs.slimjar.logging.LogDispatcher;
import me.glaremasters.guilds.libs.slimjar.logging.MediatingProcessLogger;
import me.glaremasters.guilds.libs.slimjar.logging.ProcessLogger;
import me.glaremasters.guilds.libs.slimjar.relocation.JarFileRelocatorFactory;
import me.glaremasters.guilds.libs.slimjar.relocation.RelocatorFactory;
import me.glaremasters.guilds.libs.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import me.glaremasters.guilds.libs.slimjar.relocation.facade.ReflectiveJarRelocatorFacadeFactory;
import me.glaremasters.guilds.libs.slimjar.relocation.helper.RelocationHelperFactory;
import me.glaremasters.guilds.libs.slimjar.relocation.helper.VerifyingRelocationHelperFactory;
import me.glaremasters.guilds.libs.slimjar.relocation.meta.FlatFileMetaMediatorFactory;
import me.glaremasters.guilds.libs.slimjar.relocation.meta.MetaMediatorFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.CachingDependencyResolverFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.DependencyResolverFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;
import me.glaremasters.guilds.libs.slimjar.resolver.enquirer.PingingRepositoryEnquirerFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.mirrors.MirrorSelector;
import me.glaremasters.guilds.libs.slimjar.resolver.mirrors.SimpleMirrorSelector;
import me.glaremasters.guilds.libs.slimjar.resolver.pinger.HttpURLPinger;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.dependency.ExternalDependencyDataProviderFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.dependency.GsonDependencyDataProviderFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.facade.GsonFacadeFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.facade.ReflectiveGsonFacadeFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.resolution.GsonPreResolutionDataProviderFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.resolution.PreResolutionDataProviderFactory;
import me.glaremasters.guilds.libs.slimjar.resolver.strategy.MavenChecksumPathResolutionStrategy;
import me.glaremasters.guilds.libs.slimjar.resolver.strategy.MavenPathResolutionStrategy;
import me.glaremasters.guilds.libs.slimjar.resolver.strategy.MavenPomPathResolutionStrategy;
import me.glaremasters.guilds.libs.slimjar.resolver.strategy.MavenSnapshotPathResolutionStrategy;
import me.glaremasters.guilds.libs.slimjar.resolver.strategy.MediatingPathResolutionStrategy;

public abstract class ApplicationBuilder {
    private static final Path DEFAULT_DOWNLOAD_DIRECTORY;
    private final String applicationName;
    private URL dependencyFileUrl;
    private URL preResolutionFileUrl;
    private Path downloadDirectoryPath;
    private RelocatorFactory relocatorFactory;
    private DependencyDataProviderFactory moduleDataProviderFactory;
    private DependencyDataProviderFactory dataProviderFactory;
    private PreResolutionDataProviderFactory preResolutionDataProviderFactory;
    private RelocationHelperFactory relocationHelperFactory;
    private DependencyInjectorFactory injectorFactory;
    private DependencyResolverFactory resolverFactory;
    private RepositoryEnquirerFactory enquirerFactory;
    private DependencyDownloaderFactory downloaderFactory;
    private DependencyVerifierFactory verifierFactory;
    private MirrorSelector mirrorSelector;
    private Collection<Repository> internalRepositories;
    private ProcessLogger logger;

    protected ApplicationBuilder(String string) {
        this.applicationName = Objects.requireNonNull(string, "Requires non-null application name!");
    }

    public static ApplicationBuilder isolated(String string, IsolationConfiguration isolationConfiguration, Object[] objectArray) {
        return new IsolatedApplicationBuilder(string, isolationConfiguration, objectArray);
    }

    public static ApplicationBuilder appending(String string) {
        return InjectingApplicationBuilder.createAppending(string);
    }

    public static ApplicationBuilder injecting(String string, Injectable injectable) {
        return new InjectingApplicationBuilder(string, injectable);
    }

    public final ApplicationBuilder dependencyFileUrl(URL uRL) {
        this.dependencyFileUrl = uRL;
        return this;
    }

    public final ApplicationBuilder preResolutionFileUrl(URL uRL) {
        this.preResolutionFileUrl = uRL;
        return this;
    }

    public final ApplicationBuilder downloadDirectoryPath(Path path) {
        this.downloadDirectoryPath = path;
        return this;
    }

    public final ApplicationBuilder relocatorFactory(RelocatorFactory relocatorFactory) {
        this.relocatorFactory = relocatorFactory;
        return this;
    }

    public final ApplicationBuilder moduleDataProviderFactory(DependencyDataProviderFactory dependencyDataProviderFactory) {
        this.moduleDataProviderFactory = dependencyDataProviderFactory;
        return this;
    }

    public final ApplicationBuilder dataProviderFactory(DependencyDataProviderFactory dependencyDataProviderFactory) {
        this.dataProviderFactory = dependencyDataProviderFactory;
        return this;
    }

    public final ApplicationBuilder preResolutionDataProviderFactory(PreResolutionDataProviderFactory preResolutionDataProviderFactory) {
        this.preResolutionDataProviderFactory = preResolutionDataProviderFactory;
        return this;
    }

    public final ApplicationBuilder relocationHelperFactory(RelocationHelperFactory relocationHelperFactory) {
        this.relocationHelperFactory = relocationHelperFactory;
        return this;
    }

    public final ApplicationBuilder injectorFactory(DependencyInjectorFactory dependencyInjectorFactory) {
        this.injectorFactory = dependencyInjectorFactory;
        return this;
    }

    public final ApplicationBuilder resolverFactory(DependencyResolverFactory dependencyResolverFactory) {
        this.resolverFactory = dependencyResolverFactory;
        return this;
    }

    public final ApplicationBuilder enquirerFactory(RepositoryEnquirerFactory repositoryEnquirerFactory) {
        this.enquirerFactory = repositoryEnquirerFactory;
        return this;
    }

    public final ApplicationBuilder downloaderFactory(DependencyDownloaderFactory dependencyDownloaderFactory) {
        this.downloaderFactory = dependencyDownloaderFactory;
        return this;
    }

    public final ApplicationBuilder verifierFactory(DependencyVerifierFactory dependencyVerifierFactory) {
        this.verifierFactory = dependencyVerifierFactory;
        return this;
    }

    public final ApplicationBuilder mirrorSelector(MirrorSelector mirrorSelector) {
        this.mirrorSelector = mirrorSelector;
        return this;
    }

    public final ApplicationBuilder internalRepositories(Collection<Repository> collection) {
        this.internalRepositories = collection;
        return this;
    }

    public final ApplicationBuilder logger(ProcessLogger processLogger) {
        this.logger = processLogger;
        return this;
    }

    protected final String getApplicationName() {
        return this.applicationName;
    }

    protected final URL getDependencyFileUrl() {
        if (this.dependencyFileUrl == null) {
            this.dependencyFileUrl = this.getClass().getClassLoader().getResource("slimjar.json");
        }
        return this.dependencyFileUrl;
    }

    protected final URL getPreResolutionFileUrl() {
        if (this.preResolutionFileUrl == null) {
            this.preResolutionFileUrl = this.getClass().getClassLoader().getResource("slimjar-resolutions.json");
        }
        return this.preResolutionFileUrl;
    }

    protected final Path getDownloadDirectoryPath() {
        if (this.downloadDirectoryPath == null) {
            this.downloadDirectoryPath = DEFAULT_DOWNLOAD_DIRECTORY;
        }
        return this.downloadDirectoryPath;
    }

    protected final RelocatorFactory getRelocatorFactory() {
        if (this.relocatorFactory == null) {
            JarRelocatorFacadeFactory jarRelocatorFacadeFactory = ReflectiveJarRelocatorFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.relocatorFactory = new JarFileRelocatorFactory(jarRelocatorFacadeFactory);
        }
        return this.relocatorFactory;
    }

    protected final DependencyDataProviderFactory getModuleDataProviderFactory() {
        if (this.moduleDataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.moduleDataProviderFactory = new ExternalDependencyDataProviderFactory(gsonFacadeFactory);
        }
        return this.moduleDataProviderFactory;
    }

    protected final DependencyDataProviderFactory getDataProviderFactory() {
        if (this.dataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.dataProviderFactory = new GsonDependencyDataProviderFactory(gsonFacadeFactory);
        }
        return this.dataProviderFactory;
    }

    protected final PreResolutionDataProviderFactory getPreResolutionDataProviderFactory() {
        if (this.preResolutionDataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.preResolutionDataProviderFactory = new GsonPreResolutionDataProviderFactory(gsonFacadeFactory);
        }
        return this.preResolutionDataProviderFactory;
    }

    protected final RelocationHelperFactory getRelocationHelperFactory() {
        if (this.relocationHelperFactory == null) {
            FileChecksumCalculator fileChecksumCalculator = new FileChecksumCalculator("SHA-256");
            FilePathStrategy filePathStrategy = FilePathStrategy.createRelocationStrategy(this.getDownloadDirectoryPath().toFile(), this.getApplicationName());
            FlatFileMetaMediatorFactory flatFileMetaMediatorFactory = new FlatFileMetaMediatorFactory();
            this.relocationHelperFactory = new VerifyingRelocationHelperFactory(fileChecksumCalculator, filePathStrategy, (MetaMediatorFactory)flatFileMetaMediatorFactory);
        }
        return this.relocationHelperFactory;
    }

    protected final DependencyInjectorFactory getInjectorFactory() {
        if (this.injectorFactory == null) {
            this.injectorFactory = new SimpleDependencyInjectorFactory();
        }
        return this.injectorFactory;
    }

    protected final DependencyResolverFactory getResolverFactory() {
        if (this.resolverFactory == null) {
            HttpURLPinger httpURLPinger = new HttpURLPinger();
            this.resolverFactory = new CachingDependencyResolverFactory(httpURLPinger);
        }
        return this.resolverFactory;
    }

    protected final RepositoryEnquirerFactory getEnquirerFactory() {
        if (this.enquirerFactory == null) {
            MavenPathResolutionStrategy mavenPathResolutionStrategy = new MavenPathResolutionStrategy();
            MavenSnapshotPathResolutionStrategy mavenSnapshotPathResolutionStrategy = new MavenSnapshotPathResolutionStrategy();
            MediatingPathResolutionStrategy mediatingPathResolutionStrategy = new MediatingPathResolutionStrategy(mavenPathResolutionStrategy, mavenSnapshotPathResolutionStrategy);
            MavenPomPathResolutionStrategy mavenPomPathResolutionStrategy = new MavenPomPathResolutionStrategy();
            MavenChecksumPathResolutionStrategy mavenChecksumPathResolutionStrategy = new MavenChecksumPathResolutionStrategy("SHA-1", mediatingPathResolutionStrategy);
            HttpURLPinger httpURLPinger = new HttpURLPinger();
            this.enquirerFactory = new PingingRepositoryEnquirerFactory(mediatingPathResolutionStrategy, mavenChecksumPathResolutionStrategy, mavenPomPathResolutionStrategy, httpURLPinger);
        }
        return this.enquirerFactory;
    }

    protected final DependencyDownloaderFactory getDownloaderFactory() {
        if (this.downloaderFactory == null) {
            this.downloaderFactory = new URLDependencyDownloaderFactory();
        }
        return this.downloaderFactory;
    }

    protected final DependencyVerifierFactory getVerifierFactory() {
        if (this.verifierFactory == null) {
            FilePathStrategy filePathStrategy = ChecksumFilePathStrategy.createStrategy(this.getDownloadDirectoryPath().toFile(), "SHA-1");
            DependencyOutputWriterFactory dependencyOutputWriterFactory = new DependencyOutputWriterFactory(filePathStrategy);
            PassthroughDependencyVerifierFactory passthroughDependencyVerifierFactory = new PassthroughDependencyVerifierFactory();
            FileChecksumCalculator fileChecksumCalculator = new FileChecksumCalculator("SHA-1");
            this.verifierFactory = new ChecksumDependencyVerifierFactory(dependencyOutputWriterFactory, passthroughDependencyVerifierFactory, fileChecksumCalculator);
        }
        return this.verifierFactory;
    }

    protected final MirrorSelector getMirrorSelector() {
        if (this.mirrorSelector == null) {
            this.mirrorSelector = new SimpleMirrorSelector(this.getInternalRepositories());
        }
        return this.mirrorSelector;
    }

    protected final Collection<Repository> getInternalRepositories() {
        if (this.internalRepositories == null) {
            this.internalRepositories = Collections.singleton(new Repository(new URL("https://repo1.maven.org/maven2/")));
        }
        return this.internalRepositories;
    }

    protected final ProcessLogger getLogger() {
        if (this.logger == null) {
            this.logger = (string, objectArray) -> {};
        }
        return this.logger;
    }

    protected final DependencyInjector createInjector() {
        InjectionHelperFactory injectionHelperFactory = new InjectionHelperFactory(this.getDownloadDirectoryPath(), this.getRelocatorFactory(), this.getDataProviderFactory(), this.getRelocationHelperFactory(), this.getInjectorFactory(), this.getResolverFactory(), this.getEnquirerFactory(), this.getDownloaderFactory(), this.getVerifierFactory(), this.getMirrorSelector());
        return this.getInjectorFactory().create(injectionHelperFactory);
    }

    public final Application build() {
        MediatingProcessLogger mediatingProcessLogger = LogDispatcher.getMediatingLogger();
        ProcessLogger processLogger = this.getLogger();
        mediatingProcessLogger.addLogger(processLogger);
        Application application = this.buildApplication();
        mediatingProcessLogger.removeLogger(processLogger);
        return application;
    }

    protected abstract Application buildApplication();

    static {
        String string = System.getProperty("user.home");
        String string2 = String.format("%s/.slimjar", string);
        DEFAULT_DOWNLOAD_DIRECTORY = new File(string2).toPath();
    }
}

