/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.app.module;

import java.io.File;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.glaremasters.guilds.libs.slimjar.app.module.ModuleExtractor;
import me.glaremasters.guilds.libs.slimjar.app.module.ModuleNotFoundException;

public final class TemporaryModuleExtractor
implements ModuleExtractor {
    @Override
    public URL extractModule(URL uRL, String string) {
        File file = File.createTempFile(string, ".jar");
        file.deleteOnExit();
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof JarURLConnection)) {
            throw new AssertionError((Object)"Invalid Module URL provided(Non-Jar File)");
        }
        JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
        JarFile jarFile = jarURLConnection.getJarFile();
        JarEntry jarEntry = jarFile.getJarEntry(string + ".isolated-jar");
        if (jarEntry == null) {
            throw new ModuleNotFoundException(string);
        }
        try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return file.toURI().toURL();
    }
}

