/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.downloader;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import me.glaremasters.guilds.libs.slimjar.downloader.DependencyDownloader;
import me.glaremasters.guilds.libs.slimjar.downloader.output.OutputWriter;
import me.glaremasters.guilds.libs.slimjar.downloader.output.OutputWriterFactory;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.DependencyVerifier;
import me.glaremasters.guilds.libs.slimjar.logging.LogDispatcher;
import me.glaremasters.guilds.libs.slimjar.logging.ProcessLogger;
import me.glaremasters.guilds.libs.slimjar.resolver.DependencyResolver;
import me.glaremasters.guilds.libs.slimjar.resolver.ResolutionResult;
import me.glaremasters.guilds.libs.slimjar.resolver.UnresolvedDependencyException;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Dependency;
import me.glaremasters.guilds.libs.slimjar.util.Connections;

public final class URLDependencyDownloader
implements DependencyDownloader {
    private static final byte[] BOM_BYTES = "bom-file".getBytes();
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final OutputWriterFactory outputWriterProducer;
    private final DependencyResolver dependencyResolver;
    private final DependencyVerifier verifier;

    public URLDependencyDownloader(OutputWriterFactory outputWriterFactory, DependencyResolver dependencyResolver, DependencyVerifier dependencyVerifier) {
        this.outputWriterProducer = outputWriterFactory;
        this.dependencyResolver = dependencyResolver;
        this.verifier = dependencyVerifier;
    }

    @Override
    public File download(Dependency dependency) {
        File file = this.outputWriterProducer.getStrategy().selectFileFor(dependency);
        if (file.exists() && file.length() == (long)BOM_BYTES.length && Arrays.equals(Files.readAllBytes(file.toPath()), BOM_BYTES)) {
            return null;
        }
        if (this.verifier.verify(file, dependency)) {
            return file;
        }
        ResolutionResult resolutionResult = this.dependencyResolver.resolve(dependency).orElseThrow(() -> new UnresolvedDependencyException(dependency));
        if (resolutionResult.isAggregator()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
            Files.write(file.toPath(), BOM_BYTES, new OpenOption[0]);
            return null;
        }
        file.delete();
        File file2 = this.verifier.getChecksumFile(dependency);
        if (file2 != null) {
            file2.delete();
        }
        LOGGER.log("Downloading {0}...", dependency.getArtifactId());
        URL uRL = resolutionResult.getDependencyURL();
        LOGGER.debug("Connecting to {0}", uRL);
        URLConnection uRLConnection = Connections.createDownloadConnection(uRL);
        InputStream inputStream = uRLConnection.getInputStream();
        LOGGER.debug("Connection successful! Downloading {0}", dependency.getArtifactId() + "...");
        OutputWriter outputWriter = this.outputWriterProducer.create(dependency);
        LOGGER.debug("{0}.Size = {1}", dependency.getArtifactId(), uRLConnection.getContentLength());
        File file3 = outputWriter.writeFrom(inputStream, uRLConnection.getContentLength());
        Connections.tryDisconnect(uRLConnection);
        this.verifier.verify(file3, dependency);
        LOGGER.debug("Artifact {0} downloaded successfully!", dependency.getArtifactId());
        LOGGER.log("Downloaded {0} successfully!", dependency.getArtifactId());
        return file3;
    }
}

