/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.injector.loader.manifest;

import java.io.BufferedWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import me.glaremasters.guilds.libs.slimjar.injector.loader.manifest.ManifestGenerator;

public final class JarManifestGenerator
implements ManifestGenerator {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final URI jarURI;

    public JarManifestGenerator(URI uRI) {
        this.jarURI = uRI;
    }

    @Override
    public ManifestGenerator attribute(String string, String string2) {
        this.attributes.put(string, string2);
        return this;
    }

    @Override
    public void generate() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("create", "true");
        URI uRI = URI.create(String.format("jar:%s", this.jarURI));
        try (FileSystem fileSystem = FileSystems.newFileSystem(uRI, hashMap);){
            Path path = fileSystem.getPath("META-INF/MANIFEST.MF", new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
                for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                    bufferedWriter.write(String.format("%s: %s%n", entry.getKey(), entry.getValue()));
                }
            }
        }
    }

    public static ManifestGenerator with(URI uRI) {
        return new JarManifestGenerator(uRI);
    }
}

