/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.relocation;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public final class RelocationRule {
    private final String originalPackagePattern;
    private final String relocatedPackagePattern;
    private final Collection<String> exclusions;
    private final Collection<String> inclusions;

    public RelocationRule(String string, String string2, Collection<String> collection, Collection<String> collection2) {
        this.originalPackagePattern = string;
        this.relocatedPackagePattern = string2;
        this.exclusions = collection;
        this.inclusions = collection2;
    }

    public RelocationRule(String string, String string2) {
        this(string, string2, Collections.emptyList(), Collections.emptyList());
    }

    public String getOriginalPackagePattern() {
        return this.originalPackagePattern;
    }

    public String getRelocatedPackagePattern() {
        return this.relocatedPackagePattern;
    }

    public Collection<String> getExclusions() {
        return this.exclusions;
    }

    public Collection<String> getInclusions() {
        return this.inclusions;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RelocationRule relocationRule = (RelocationRule)object;
        return this.originalPackagePattern.equals(relocationRule.originalPackagePattern) && this.relocatedPackagePattern.equals(relocationRule.relocatedPackagePattern);
    }

    public int hashCode() {
        return Objects.hash(this.originalPackagePattern, this.relocatedPackagePattern);
    }

    public String toString() {
        return "RelocationRule{originalPackagePattern='" + this.originalPackagePattern + '\'' + ", relocatedPackagePattern='" + this.relocatedPackagePattern + '\'' + '}';
    }
}

