/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.relocation.helper;

import java.io.File;
import java.net.URL;
import me.glaremasters.guilds.libs.slimjar.downloader.strategy.FilePathStrategy;
import me.glaremasters.guilds.libs.slimjar.downloader.verify.FileChecksumCalculator;
import me.glaremasters.guilds.libs.slimjar.relocation.Relocator;
import me.glaremasters.guilds.libs.slimjar.relocation.helper.RelocationHelper;
import me.glaremasters.guilds.libs.slimjar.relocation.helper.RelocationHelperFactory;
import me.glaremasters.guilds.libs.slimjar.relocation.helper.VerifyingRelocationHelper;
import me.glaremasters.guilds.libs.slimjar.relocation.meta.MetaMediatorFactory;

public class VerifyingRelocationHelperFactory
implements RelocationHelperFactory {
    private static final URL JAR_URL = VerifyingRelocationHelperFactory.class.getProtectionDomain().getCodeSource().getLocation();
    private final FilePathStrategy relocationFilePathStrategy;
    private final MetaMediatorFactory mediatorFactory;
    private final String selfHash;

    public VerifyingRelocationHelperFactory(String string, FilePathStrategy filePathStrategy, MetaMediatorFactory metaMediatorFactory) {
        this.relocationFilePathStrategy = filePathStrategy;
        this.mediatorFactory = metaMediatorFactory;
        this.selfHash = string;
    }

    public VerifyingRelocationHelperFactory(FileChecksumCalculator fileChecksumCalculator, FilePathStrategy filePathStrategy, MetaMediatorFactory metaMediatorFactory) {
        this(fileChecksumCalculator.calculate(new File(JAR_URL.toURI())), filePathStrategy, metaMediatorFactory);
    }

    @Override
    public RelocationHelper create(Relocator relocator) {
        return new VerifyingRelocationHelper(this.selfHash, this.relocationFilePathStrategy, relocator, this.mediatorFactory);
    }
}

