/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.resolver;

import java.net.URL;
import java.util.Objects;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;

public final class ResolutionResult {
    private final Repository repository;
    private final URL dependencyURL;
    private final URL checksumURL;
    private final boolean isAggregator;

    public ResolutionResult(Repository repository, URL uRL, URL uRL2, boolean bl) {
        this.repository = repository;
        this.dependencyURL = uRL;
        this.checksumURL = uRL2;
        this.isAggregator = bl;
        if (!bl) {
            Objects.requireNonNull(uRL, "Resolved URL must not be null for non-aggregator dependencies");
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public URL getDependencyURL() {
        return this.dependencyURL;
    }

    public URL getChecksumURL() {
        return this.checksumURL;
    }

    public boolean isAggregator() {
        return this.isAggregator;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ResolutionResult resolutionResult = (ResolutionResult)object;
        return this.dependencyURL.toString().equals(resolutionResult.toString()) && Objects.equals(this.checksumURL.toString(), resolutionResult.getChecksumURL().toString()) && this.isAggregator == resolutionResult.isAggregator;
    }

    public int hashCode() {
        return Objects.hash(this.dependencyURL.toString(), this.checksumURL.toString(), this.isAggregator);
    }
}

