/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.resolver.mirrors;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Mirror;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;
import me.glaremasters.guilds.libs.slimjar.resolver.mirrors.MirrorSelector;

public final class SimpleMirrorSelector
implements MirrorSelector {
    public static final String CENTRAL_URL = "https://repo.maven.apache.org/maven2/";
    public static final String ALT_CENTRAL_URL = "https://repo1.maven.org/maven2/";
    public static final String DEFAULT_CENTRAL_MIRROR_URL = "https://repo1.maven.org/maven2/";
    private static final Collection<String> CENTRAL_REPO = Arrays.asList("https://repo.maven.apache.org/maven2/", "https://repo1.maven.org/maven2/");
    private final Collection<Repository> centralMirrors;

    public SimpleMirrorSelector(Collection<Repository> collection) {
        this.centralMirrors = collection;
    }

    @Override
    public Collection<Repository> select(Collection<Repository> collection, Collection<Mirror> collection2) {
        Collection collection3 = collection2.stream().map(Mirror::getOriginal).collect(Collectors.toSet());
        Collection collection4 = collection.stream().filter(repository -> !collection3.contains(repository.getUrl())).filter(repository -> !SimpleMirrorSelector.isCentral(repository)).collect(Collectors.toSet());
        Collection collection5 = collection2.stream().map(Mirror::getMirroring).map(Repository::new).collect(Collectors.toSet());
        collection4.addAll(collection5);
        collection4.addAll(this.centralMirrors);
        return collection4;
    }

    private static boolean isCentral(Repository repository) {
        String string = repository.getUrl().toString();
        return CENTRAL_REPO.contains(string);
    }
}

