/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.resolver.reader.dependency;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import me.glaremasters.guilds.libs.slimjar.resolver.data.DependencyData;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.dependency.DependencyDataProvider;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.dependency.DependencyReader;

public final class ModuleDependencyDataProvider
implements DependencyDataProvider {
    private final DependencyReader dependencyReader;
    private final URL moduleUrl;

    public ModuleDependencyDataProvider(DependencyReader dependencyReader, URL uRL) {
        this.dependencyReader = dependencyReader;
        this.moduleUrl = uRL;
    }

    @Override
    public DependencyData get() {
        URL uRL = new URL("jar:file:" + this.moduleUrl.getFile() + "!/slimjar.json");
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof JarURLConnection)) {
            throw new AssertionError((Object)"Invalid Module URL provided(Non-Jar File)");
        }
        JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
        JarFile jarFile = jarURLConnection.getJarFile();
        ZipEntry zipEntry = jarFile.getEntry("slimjar.json");
        if (zipEntry == null) {
            return new DependencyData(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        try (InputStream inputStream = jarFile.getInputStream(zipEntry);){
            DependencyData dependencyData = this.dependencyReader.read(inputStream);
            return dependencyData;
        }
    }
}

