/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.resolver.reader.facade;

import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import me.glaremasters.guilds.libs.slimjar.resolver.reader.facade.GsonFacade;

public final class ReflectiveGsonFacade
implements GsonFacade {
    private final Object gson;
    private final Method gsonFromJsonMethod;
    private final Method gsonFromJsonTypeMethod;
    private final Method canonicalizeMethod;

    ReflectiveGsonFacade(Object object, Method method, Method method2, Method method3) {
        this.gson = object;
        this.gsonFromJsonMethod = method;
        this.gsonFromJsonTypeMethod = method2;
        this.canonicalizeMethod = method3;
    }

    @Override
    public <T> T fromJson(InputStreamReader inputStreamReader, Class<T> clazz) {
        Object object = this.gsonFromJsonMethod.invoke(this.gson, inputStreamReader, clazz);
        if (clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        throw new AssertionError((Object)"Gson returned wrong type!");
    }

    @Override
    public <T> T fromJson(InputStreamReader inputStreamReader, Type type) {
        Object object = this.canonicalizeMethod.invoke(null, type);
        Object object2 = this.gsonFromJsonTypeMethod.invoke(this.gson, inputStreamReader, object);
        return (T)object2;
    }
}

