/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.slimjar.util;

import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.slimjar.app.module.ModuleExtractor;

public final class Modules {
    private Modules() {
    }

    public static URL findModule(String string) {
        ClassLoader classLoader = Modules.class.getClassLoader();
        return classLoader.getResource(string + ".isolated-jar");
    }

    public static URL[] extract(ModuleExtractor moduleExtractor, Collection<String> collection) {
        URL[] uRLArray = new URL[collection.size()];
        int n = 0;
        for (String string : collection) {
            URL uRL = Modules.findModule(string);
            URL uRL2 = moduleExtractor.extractModule(uRL, string);
            uRLArray[n++] = uRL2;
        }
        return uRLArray;
    }

    public static Collection<String> findLocalModules() {
        URL uRL = Modules.class.getProtectionDomain().getCodeSource().getLocation();
        Path path2 = Paths.get(uRL.toURI());
        return Files.walk(path2, 1, new FileVisitOption[0]).filter(path -> path.endsWith(".isolated-jar")).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
    }
}

