/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.taskchain;

import java.util.concurrent.TimeUnit;
import me.glaremasters.guilds.libs.taskchain.AsyncQueue;
import me.glaremasters.guilds.libs.taskchain.GameInterface;
import me.glaremasters.guilds.libs.taskchain.TaskChain;
import me.glaremasters.guilds.libs.taskchain.TaskChainAbortAction;
import me.glaremasters.guilds.libs.taskchain.TaskChainAsyncQueue;
import me.glaremasters.guilds.libs.taskchain.TaskChainFactory;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

public class BukkitTaskChainFactory
extends TaskChainFactory {
    public static final TaskChainAbortAction<Player, String, ?> MESSAGE = new TaskChainAbortAction<Player, String, Object>(){

        @Override
        public void onAbort(TaskChain<?> taskChain, Player player, String string) {
            player.sendMessage(string);
        }
    };
    public static final TaskChainAbortAction<Player, String, ?> COLOR_MESSAGE = new TaskChainAbortAction<Player, String, Object>(){

        @Override
        public void onAbort(TaskChain<?> taskChain, Player player, String string) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        }
    };

    private BukkitTaskChainFactory(Plugin plugin, AsyncQueue asyncQueue) {
        super(new BukkitGameInterface(plugin, asyncQueue));
    }

    public static TaskChainFactory create(Plugin plugin) {
        return new BukkitTaskChainFactory(plugin, new TaskChainAsyncQueue());
    }

    private static class BukkitGameInterface
    implements GameInterface {
        private final Plugin plugin;
        private final AsyncQueue asyncQueue;

        BukkitGameInterface(Plugin plugin, AsyncQueue asyncQueue) {
            this.plugin = plugin;
            this.asyncQueue = asyncQueue;
        }

        @Override
        public AsyncQueue getAsyncQueue() {
            return this.asyncQueue;
        }

        @Override
        public boolean isMainThread() {
            return Bukkit.isPrimaryThread();
        }

        @Override
        public void postToMain(Runnable runnable) {
            if (this.plugin.isEnabled()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, runnable);
            } else {
                runnable.run();
            }
        }

        @Override
        public void scheduleTask(int n, Runnable runnable) {
            if (this.plugin.isEnabled()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, runnable, (long)n);
            } else {
                runnable.run();
            }
        }

        @Override
        public void registerShutdownHandler(final TaskChainFactory taskChainFactory) {
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onPluginDisable(PluginDisableEvent pluginDisableEvent) {
                    if (pluginDisableEvent.getPlugin().equals(plugin)) {
                        taskChainFactory.shutdown(60, TimeUnit.SECONDS);
                    }
                }
            }, this.plugin);
        }
    }
}

