/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.taskchain;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.glaremasters.guilds.libs.taskchain.TaskChain;
import me.glaremasters.guilds.libs.taskchain.TaskChainFactory;
import me.glaremasters.guilds.libs.taskchain.TaskChainTasks;

class SharedTaskChain<R>
extends TaskChain<R> {
    private final String name;
    private final Map<String, Queue<SharedTaskChain>> sharedChains;
    private Queue<SharedTaskChain> queue;
    private volatile boolean isPending;
    private volatile boolean canExecute = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SharedTaskChain(String string, TaskChainFactory taskChainFactory) {
        super(taskChainFactory);
        this.sharedChains = taskChainFactory.getSharedChains();
        this.name = string;
        Map<String, Queue<SharedTaskChain>> map = this.sharedChains;
        synchronized (map) {
            this.queue = this.sharedChains.get(this.name);
            if (this.queue == null) {
                this.queue = new ConcurrentLinkedQueue<SharedTaskChain>();
                this.sharedChains.put(this.name, this.queue);
            }
            this.queue.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Consumer<Boolean> consumer, BiConsumer<Exception, TaskChainTasks.Task<?, ?>> biConsumer) {
        boolean bl2;
        this.setErrorHandler(biConsumer);
        this.setDoneCallback(bl -> {
            this.setDoneCallback(consumer);
            this.done((boolean)bl);
            this.processQueue();
        });
        Map<String, Queue<SharedTaskChain>> map = this.sharedChains;
        synchronized (map) {
            this.isPending = this.queue.peek() != this;
            boolean bl3 = bl2 = !this.isPending && this.canExecute;
            if (bl2) {
                this.canExecute = false;
            }
        }
        if (bl2) {
            this.execute0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        SharedTaskChain sharedTaskChain;
        this.queue.poll();
        Map<String, Queue<SharedTaskChain>> map = this.sharedChains;
        synchronized (map) {
            sharedTaskChain = this.queue.peek();
            if (sharedTaskChain == null) {
                this.sharedChains.remove(this.name);
                return;
            }
            if (!sharedTaskChain.isPending) {
                return;
            }
            this.canExecute = false;
        }
        sharedTaskChain.execute0();
    }
}

