/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.taskchain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.taskchain.AbortChainException;
import me.glaremasters.guilds.libs.taskchain.GameInterface;
import me.glaremasters.guilds.libs.taskchain.TaskChainAbortAction;
import me.glaremasters.guilds.libs.taskchain.TaskChainDataWrappers;
import me.glaremasters.guilds.libs.taskchain.TaskChainFactory;
import me.glaremasters.guilds.libs.taskchain.TaskChainTasks;
import me.glaremasters.guilds.libs.taskchain.TaskChainUtil;

public class TaskChain<T> {
    private static final ThreadLocal<TaskChain<?>> currentChain = new ThreadLocal();
    private final GameInterface impl;
    private final TaskChainFactory factory;
    private final Map<String, Object> taskMap = new HashMap<String, Object>(0);
    private final ConcurrentLinkedQueue<TaskHolder<?, ?>> chainQueue = new ConcurrentLinkedQueue();
    private int currentActionIndex = 0;
    private int actionIndex = 0;
    private boolean executed = false;
    private boolean async = false;
    private boolean done = false;
    private Object previous;
    private TaskHolder<?, ?> currentHolder;
    private Consumer<Boolean> doneCallback;
    private BiConsumer<Exception, TaskChainTasks.Task<?, ?>> errorHandler;

    TaskChain(TaskChainFactory taskChainFactory) {
        this.factory = taskChainFactory;
        this.impl = taskChainFactory.getImplementation();
    }

    public int getCurrentActionIndex() {
        return this.currentActionIndex;
    }

    public void setDoneCallback(Consumer<Boolean> consumer) {
        this.doneCallback = consumer;
    }

    public BiConsumer<Exception, TaskChainTasks.Task<?, ?>> getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(BiConsumer<Exception, TaskChainTasks.Task<?, ?>> biConsumer) {
        this.errorHandler = biConsumer;
    }

    public static <D1, D2> TaskChainDataWrappers.Data2<D1, D2> multi(D1 D1, D2 D2) {
        return new TaskChainDataWrappers.Data2<D1, D2>(D1, D2);
    }

    public static <D1, D2, D3> TaskChainDataWrappers.Data3<D1, D2, D3> multi(D1 D1, D2 D2, D3 D3) {
        return new TaskChainDataWrappers.Data3<D1, D2, D3>(D1, D2, D3);
    }

    public static <D1, D2, D3, D4> TaskChainDataWrappers.Data4<D1, D2, D3, D4> multi(D1 D1, D2 D2, D3 D3, D4 D4) {
        return new TaskChainDataWrappers.Data4<D1, D2, D3, D4>(D1, D2, D3, D4);
    }

    public static <D1, D2, D3, D4, D5> TaskChainDataWrappers.Data5<D1, D2, D3, D4, D5> multi(D1 D1, D2 D2, D3 D3, D4 D4, D5 D5) {
        return new TaskChainDataWrappers.Data5<D1, D2, D3, D4, D5>(D1, D2, D3, D4, D5);
    }

    public static <D1, D2, D3, D4, D5, D6> TaskChainDataWrappers.Data6<D1, D2, D3, D4, D5, D6> multi(D1 D1, D2 D2, D3 D3, D4 D4, D5 D5, D6 D6) {
        return new TaskChainDataWrappers.Data6<D1, D2, D3, D4, D5, D6>(D1, D2, D3, D4, D5, D6);
    }

    public static void abort() {
        TaskChainUtil.sneakyThrows(new AbortChainException());
    }

    public static TaskChain<?> getCurrentChain() {
        return currentChain.get();
    }

    public TaskChain<T> configure(Consumer<TaskChain<T>> consumer) {
        consumer.accept(this);
        return this;
    }

    public boolean hasTaskData(String string) {
        return this.taskMap.containsKey(string);
    }

    public <R> R getTaskData(String string) {
        return (R)this.taskMap.get(string);
    }

    public <R> R setTaskData(String string, Object object) {
        return (R)this.taskMap.put(string, object);
    }

    public <R> R removeTaskData(String string) {
        return (R)this.taskMap.remove(string);
    }

    public TaskChain<T> storeAsData(String string) {
        return this.current((T object) -> {
            this.setTaskData(string, object);
            return object;
        });
    }

    public <R> TaskChain<R> returnData(String string) {
        return this.currentFirst(() -> this.getTaskData(string));
    }

    public TaskChain<TaskChain<?>> returnChain() {
        return this.currentFirst(() -> this);
    }

    public TaskChain<T> delay(int n) {
        return this.currentCallback((T object, Consumer<R> consumer) -> this.impl.scheduleTask(n, () -> consumer.accept(object)));
    }

    public TaskChain<T> delay(int n, TimeUnit timeUnit) {
        return this.currentCallback((T object, Consumer<R> consumer) -> this.impl.scheduleTask(n, timeUnit, () -> consumer.accept(object)));
    }

    public TaskChain<?> abortChain() {
        if (this.executed) {
            TaskChain.abort();
            return this;
        }
        return this.current(TaskChain::abort);
    }

    public TaskChain<T> abortIfNull() {
        return this.abortIfNull(null, null, null, null);
    }

    public TaskChain<T> abortIfNull(TaskChainAbortAction<?, ?, ?> taskChainAbortAction) {
        return this.abortIf(Predicate.isEqual(null), (TaskChainAbortAction)taskChainAbortAction, (Object)null, (Object)null, (Object)null);
    }

    public <A1> TaskChain<T> abortIfNull(TaskChainAbortAction<A1, ?, ?> taskChainAbortAction, A1 A1) {
        return this.abortIf(Predicate.isEqual(null), (TaskChainAbortAction)taskChainAbortAction, A1, (Object)null, (Object)null);
    }

    public <A1, A2> TaskChain<T> abortIfNull(TaskChainAbortAction<A1, A2, ?> taskChainAbortAction, A1 A1, A2 A2) {
        return this.abortIf(Predicate.isEqual(null), (TaskChainAbortAction)taskChainAbortAction, A1, A2, (Object)null);
    }

    public <A1, A2, A3> TaskChain<T> abortIfNull(TaskChainAbortAction<A1, A2, A3> taskChainAbortAction, A1 A1, A2 A2, A3 A3) {
        return this.abortIf(Predicate.isEqual(null), taskChainAbortAction, A1, A2, A3);
    }

    public TaskChain<T> abortIf(T t) {
        return this.abortIf(t, null, null, null, null);
    }

    public TaskChain<T> abortIf(T t, TaskChainAbortAction<?, ?, ?> taskChainAbortAction) {
        return this.abortIf(t, taskChainAbortAction, null, null, null);
    }

    public <A1> TaskChain<T> abortIf(T t, TaskChainAbortAction<A1, ?, ?> taskChainAbortAction, A1 A1) {
        return this.abortIf(t, taskChainAbortAction, A1, null, null);
    }

    public <A1, A2> TaskChain<T> abortIf(T t, TaskChainAbortAction<A1, A2, ?> taskChainAbortAction, A1 A1, A2 A2) {
        return this.abortIf(t, taskChainAbortAction, A1, A2, null);
    }

    public <A1, A2, A3> TaskChain<T> abortIf(T t, TaskChainAbortAction<A1, A2, A3> taskChainAbortAction, A1 A1, A2 A2, A3 A3) {
        return this.abortIf(Predicate.isEqual(t), taskChainAbortAction, A1, A2, A3);
    }

    public TaskChain<T> abortIf(Predicate<T> predicate) {
        return this.abortIf(predicate, (TaskChainAbortAction)null, (Object)null, (Object)null, (Object)null);
    }

    public TaskChain<T> abortIf(Predicate<T> predicate, TaskChainAbortAction<?, ?, ?> taskChainAbortAction) {
        return this.abortIf(predicate, (TaskChainAbortAction)taskChainAbortAction, (Object)null, (Object)null, (Object)null);
    }

    public <A1> TaskChain<T> abortIf(Predicate<T> predicate, TaskChainAbortAction<A1, ?, ?> taskChainAbortAction, A1 A1) {
        return this.abortIf(predicate, (TaskChainAbortAction)taskChainAbortAction, A1, (Object)null, (Object)null);
    }

    public <A1, A2> TaskChain<T> abortIf(Predicate<T> predicate, TaskChainAbortAction<A1, A2, ?> taskChainAbortAction, A1 A1, A2 A2) {
        return this.abortIf(predicate, (TaskChainAbortAction)taskChainAbortAction, A1, A2, (Object)null);
    }

    public <A1, A2, A3> TaskChain<T> abortIf(Predicate<T> predicate, TaskChainAbortAction<A1, A2, A3> taskChainAbortAction, A1 A1, A2 A2, A3 A3) {
        return this.current((T object4) -> {
            if (predicate.test(object4)) {
                this.handleAbortAction(taskChainAbortAction, A1, A2, A3);
                return null;
            }
            return object4;
        });
    }

    public TaskChain<T> abortIfNot(T t) {
        return this.abortIfNot(t, null, null, null, null);
    }

    public TaskChain<T> abortIfNot(T t, TaskChainAbortAction<?, ?, ?> taskChainAbortAction) {
        return this.abortIfNot(t, taskChainAbortAction, null, null, null);
    }

    public <A1> TaskChain<T> abortIfNot(T t, TaskChainAbortAction<A1, ?, ?> taskChainAbortAction, A1 A1) {
        return this.abortIfNot(t, taskChainAbortAction, A1, null, null);
    }

    public <A1, A2> TaskChain<T> abortIfNot(T t, TaskChainAbortAction<A1, A2, ?> taskChainAbortAction, A1 A1, A2 A2) {
        return this.abortIfNot(t, taskChainAbortAction, A1, A2, null);
    }

    public <A1, A2, A3> TaskChain<T> abortIfNot(T t, TaskChainAbortAction<A1, A2, A3> taskChainAbortAction, A1 A1, A2 A2, A3 A3) {
        return this.abortIfNot(Predicate.isEqual(t), taskChainAbortAction, A1, A2, A3);
    }

    public TaskChain<T> abortIfNot(Predicate<T> predicate) {
        return this.abortIfNot(predicate, (TaskChainAbortAction)null, (Object)null, (Object)null, (Object)null);
    }

    public TaskChain<T> abortIfNot(Predicate<T> predicate, TaskChainAbortAction<?, ?, ?> taskChainAbortAction) {
        return this.abortIfNot(predicate, (TaskChainAbortAction)taskChainAbortAction, (Object)null, (Object)null, (Object)null);
    }

    public <A1> TaskChain<T> abortIfNot(Predicate<T> predicate, TaskChainAbortAction<A1, ?, ?> taskChainAbortAction, A1 A1) {
        return this.abortIfNot(predicate, (TaskChainAbortAction)taskChainAbortAction, A1, (Object)null, (Object)null);
    }

    public <A1, A2> TaskChain<T> abortIfNot(Predicate<T> predicate, TaskChainAbortAction<A1, A2, ?> taskChainAbortAction, A1 A1, A2 A2) {
        return this.abortIfNot(predicate, (TaskChainAbortAction)taskChainAbortAction, A1, A2, (Object)null);
    }

    public <A1, A2, A3> TaskChain<T> abortIfNot(Predicate<T> predicate, TaskChainAbortAction<A1, A2, A3> taskChainAbortAction, A1 A1, A2 A2, A3 A3) {
        return this.abortIf(predicate.negate(), taskChainAbortAction, A1, A2, A3);
    }

    public <R> TaskChain<R> syncFirstCallback(TaskChainTasks.AsyncExecutingFirstTask<R> asyncExecutingFirstTask) {
        return this.add0(new TaskHolder(this, false, asyncExecutingFirstTask));
    }

    public <R> TaskChain<R> asyncFirstCallback(TaskChainTasks.AsyncExecutingFirstTask<R> asyncExecutingFirstTask) {
        return this.add0(new TaskHolder(this, true, asyncExecutingFirstTask));
    }

    public <R> TaskChain<R> currentFirstCallback(TaskChainTasks.AsyncExecutingFirstTask<R> asyncExecutingFirstTask) {
        return this.add0(new TaskHolder(this, null, asyncExecutingFirstTask));
    }

    public <R> TaskChain<R> syncCallback(TaskChainTasks.AsyncExecutingTask<R, T> asyncExecutingTask) {
        return this.add0(new TaskHolder(this, false, asyncExecutingTask));
    }

    public TaskChain<?> syncCallback(TaskChainTasks.AsyncExecutingGenericTask asyncExecutingGenericTask) {
        return this.add0(new TaskHolder(this, false, asyncExecutingGenericTask));
    }

    public <R> TaskChain<R> asyncCallback(TaskChainTasks.AsyncExecutingTask<R, T> asyncExecutingTask) {
        return this.add0(new TaskHolder(this, true, asyncExecutingTask));
    }

    public TaskChain<?> asyncCallback(TaskChainTasks.AsyncExecutingGenericTask asyncExecutingGenericTask) {
        return this.add0(new TaskHolder(this, true, asyncExecutingGenericTask));
    }

    public <R> TaskChain<R> currentCallback(TaskChainTasks.AsyncExecutingTask<R, T> asyncExecutingTask) {
        return this.add0(new TaskHolder(this, null, asyncExecutingTask));
    }

    public TaskChain<?> currentCallback(TaskChainTasks.AsyncExecutingGenericTask asyncExecutingGenericTask) {
        return this.add0(new TaskHolder(this, null, asyncExecutingGenericTask));
    }

    public <R> TaskChain<R> future(CompletableFuture<R> completableFuture) {
        return this.currentFuture((T object) -> completableFuture);
    }

    @SafeVarargs
    public final <R> TaskChain<List<R>> futures(CompletableFuture<R> ... completableFutureArray) {
        ArrayList<CompletableFuture<R>> arrayList = new ArrayList<CompletableFuture<R>>(completableFutureArray.length);
        Collections.addAll(arrayList, completableFutureArray);
        return this.futures(arrayList);
    }

    public <R> TaskChain<List<R>> futures(List<CompletableFuture<R>> list2) {
        return this.currentFuture((T object) -> this.getFuture(list2));
    }

    public <R> TaskChain<List<R>> syncFutures(TaskChainTasks.Task<List<CompletableFuture<R>>, T> task) {
        return this.syncFuture((T object) -> this.getFuture((List)task.run(object)));
    }

    public <R> TaskChain<List<R>> asyncFutures(TaskChainTasks.Task<List<CompletableFuture<R>>, T> task) {
        return this.asyncFuture((T object) -> this.getFuture((List)task.run(object)));
    }

    public <R> TaskChain<List<R>> currentFutures(TaskChainTasks.Task<List<CompletableFuture<R>>, T> task) {
        return this.currentFuture((T object) -> this.getFuture((List)task.run(object)));
    }

    public <R> TaskChain<List<R>> syncFirstFutures(TaskChainTasks.FirstTask<List<CompletableFuture<R>>> firstTask) {
        return this.syncFuture((T object) -> this.getFuture((List)firstTask.run()));
    }

    public <R> TaskChain<List<R>> asyncFirstFutures(TaskChainTasks.FirstTask<List<CompletableFuture<R>>> firstTask) {
        return this.asyncFuture((T object) -> this.getFuture((List)firstTask.run()));
    }

    public <R> TaskChain<List<R>> currentFirstFutures(TaskChainTasks.FirstTask<List<CompletableFuture<R>>> firstTask) {
        return this.currentFuture((T object) -> this.getFuture((List)firstTask.run()));
    }

    public <R> TaskChain<R> syncFirstFuture(TaskChainTasks.FutureFirstTask<R> futureFirstTask) {
        return this.add0(new TaskHolder(this, false, futureFirstTask));
    }

    public <R> TaskChain<R> asyncFirstFuture(TaskChainTasks.FutureFirstTask<R> futureFirstTask) {
        return this.add0(new TaskHolder(this, true, futureFirstTask));
    }

    public <R> TaskChain<R> currentFirstFuture(TaskChainTasks.FutureFirstTask<R> futureFirstTask) {
        return this.add0(new TaskHolder(this, null, futureFirstTask));
    }

    public <R> TaskChain<R> syncFuture(TaskChainTasks.FutureTask<R, T> futureTask) {
        return this.add0(new TaskHolder(this, false, futureTask));
    }

    public TaskChain<?> syncFuture(TaskChainTasks.FutureGenericTask futureGenericTask) {
        return this.add0(new TaskHolder(this, false, futureGenericTask));
    }

    public <R> TaskChain<R> asyncFuture(TaskChainTasks.FutureTask<R, T> futureTask) {
        return this.add0(new TaskHolder(this, true, futureTask));
    }

    public TaskChain<?> asyncFuture(TaskChainTasks.FutureGenericTask futureGenericTask) {
        return this.add0(new TaskHolder(this, true, futureGenericTask));
    }

    public <R> TaskChain<R> currentFuture(TaskChainTasks.FutureTask<R, T> futureTask) {
        return this.add0(new TaskHolder(this, null, futureTask));
    }

    public TaskChain<?> currentFuture(TaskChainTasks.FutureGenericTask futureGenericTask) {
        return this.add0(new TaskHolder(this, null, futureGenericTask));
    }

    public <R> TaskChain<R> syncFirst(TaskChainTasks.FirstTask<R> firstTask) {
        return this.add0(new TaskHolder(this, false, firstTask));
    }

    public <R> TaskChain<R> asyncFirst(TaskChainTasks.FirstTask<R> firstTask) {
        return this.add0(new TaskHolder(this, true, firstTask));
    }

    public <R> TaskChain<R> currentFirst(TaskChainTasks.FirstTask<R> firstTask) {
        return this.add0(new TaskHolder(this, null, firstTask));
    }

    public <R> TaskChain<R> sync(TaskChainTasks.Task<R, T> task) {
        return this.add0(new TaskHolder(this, false, task));
    }

    public TaskChain<?> sync(TaskChainTasks.GenericTask genericTask) {
        return this.add0(new TaskHolder(this, false, genericTask));
    }

    public <R> TaskChain<R> async(TaskChainTasks.Task<R, T> task) {
        return this.add0(new TaskHolder(this, true, task));
    }

    public TaskChain<?> async(TaskChainTasks.GenericTask genericTask) {
        return this.add0(new TaskHolder(this, true, genericTask));
    }

    public <R> TaskChain<R> current(TaskChainTasks.Task<R, T> task) {
        return this.add0(new TaskHolder(this, null, task));
    }

    public TaskChain<?> current(TaskChainTasks.GenericTask genericTask) {
        return this.add0(new TaskHolder(this, null, genericTask));
    }

    public TaskChain<?> syncLast(TaskChainTasks.LastTask<T> lastTask) {
        return this.add0(new TaskHolder(this, false, lastTask));
    }

    public TaskChain<?> asyncLast(TaskChainTasks.LastTask<T> lastTask) {
        return this.add0(new TaskHolder(this, true, lastTask));
    }

    public TaskChain<?> currentLast(TaskChainTasks.LastTask<T> lastTask) {
        return this.add0(new TaskHolder(this, null, lastTask));
    }

    public void execute() {
        this.execute((Consumer<Boolean>)null, null);
    }

    public void execute(Runnable runnable) {
        this.execute((Boolean bl) -> runnable.run(), null);
    }

    public void execute(Runnable runnable, BiConsumer<Exception, TaskChainTasks.Task<?, ?>> biConsumer) {
        this.execute((Boolean bl) -> runnable.run(), biConsumer);
    }

    public void execute(Consumer<Boolean> consumer) {
        this.execute(consumer, null);
    }

    public void execute(BiConsumer<Exception, TaskChainTasks.Task<?, ?>> biConsumer) {
        this.execute((Consumer<Boolean>)null, biConsumer);
    }

    public void execute(Consumer<Boolean> consumer, BiConsumer<Exception, TaskChainTasks.Task<?, ?>> biConsumer) {
        if (biConsumer == null) {
            biConsumer = this.factory.getDefaultErrorHandler();
        }
        this.doneCallback = consumer;
        this.errorHandler = biConsumer;
        this.execute0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A1, A2, A3> void handleAbortAction(TaskChainAbortAction<A1, A2, A3> taskChainAbortAction, A1 A1, A2 A2, A3 A3) {
        if (taskChainAbortAction != null) {
            TaskChain<?> taskChain = currentChain.get();
            try {
                currentChain.set(this);
                taskChainAbortAction.onAbort(this, A1, A2, A3);
            }
            catch (Exception exception) {
                TaskChainUtil.logError("TaskChain Exception in Abort Action handler: " + taskChainAbortAction.getClass().getName());
                TaskChainUtil.logError("Current Action Index was: " + this.currentActionIndex);
                exception.printStackTrace();
            }
            finally {
                currentChain.set(taskChain);
            }
        }
        TaskChain.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute0() {
        TaskChain taskChain = this;
        synchronized (taskChain) {
            if (this.executed) {
                throw new RuntimeException("Already executed");
            }
            this.executed = true;
        }
        this.async = !this.impl.isMainThread();
        this.nextTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done(boolean bl) {
        this.done = true;
        if (this.doneCallback != null) {
            TaskChain<?> taskChain = currentChain.get();
            try {
                currentChain.set(this);
                this.doneCallback.accept(bl);
            }
            catch (Exception exception) {
                this.handleError(exception, null);
            }
            finally {
                currentChain.set(taskChain);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskChain add0(TaskHolder<?, ?> taskHolder) {
        TaskChain taskChain = this;
        synchronized (taskChain) {
            if (this.executed) {
                throw new RuntimeException("TaskChain is executing");
            }
        }
        this.chainQueue.add(taskHolder);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextTask() {
        Object object = this;
        synchronized (object) {
            this.currentHolder = this.chainQueue.poll();
            if (this.currentHolder == null) {
                this.done = true;
            }
        }
        if (this.currentHolder == null) {
            this.previous = null;
            this.done(true);
            return;
        }
        object = this.currentHolder.async;
        if (object == null || this.factory.shutdown) {
            ((TaskHolder)this.currentHolder).run();
        } else if (((Boolean)object).booleanValue()) {
            if (this.async) {
                ((TaskHolder)this.currentHolder).run();
            } else {
                this.impl.postAsync(() -> {
                    this.async = true;
                    ((TaskHolder)this.currentHolder).run();
                });
            }
        } else if (this.async) {
            this.impl.postToMain(() -> {
                this.async = false;
                ((TaskHolder)this.currentHolder).run();
            });
        } else {
            ((TaskHolder)this.currentHolder).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(Throwable throwable, TaskChainTasks.Task<?, ?> task) {
        Exception exception;
        Exception exception2 = exception = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        if (this.errorHandler != null) {
            TaskChain<?> taskChain = currentChain.get();
            try {
                currentChain.set(this);
                this.errorHandler.accept(exception, task);
            }
            catch (Exception exception3) {
                TaskChainUtil.logError("TaskChain Exception in the error handler!" + exception3.getMessage());
                TaskChainUtil.logError("Current Action Index was: " + this.currentActionIndex);
                exception.printStackTrace();
            }
            finally {
                currentChain.set(taskChain);
            }
        } else {
            TaskChainUtil.logError("TaskChain Exception on " + (task != null ? task.getClass().getName() : "Done Hander") + ": " + exception.getMessage());
            TaskChainUtil.logError("Current Action Index was: " + this.currentActionIndex);
            exception.printStackTrace();
        }
    }

    private void abortExecutingChain() {
        this.previous = null;
        this.chainQueue.clear();
        this.done(false);
    }

    private <R> CompletableFuture<List<R>> getFuture(List<CompletableFuture<R>> list2) {
        CompletableFuture completableFuture = new CompletableFuture();
        CompletableFuture[] completableFutureArray = new CompletableFuture[list2.size()];
        CompletableFuture.allOf(list2.toArray(completableFutureArray)).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                completableFuture.completeExceptionally((Throwable)throwable);
            } else {
                boolean[] blArray = new boolean[]{false};
                List list3 = list2.stream().map(completableFuture -> {
                    try {
                        return completableFuture.join();
                    }
                    catch (Exception exception) {
                        blArray[0] = true;
                        this.handleError(exception, ((TaskHolder)this.currentHolder).task);
                        return null;
                    }
                }).collect(Collectors.toList());
                if (blArray[0]) {
                    completableFuture.completeExceptionally(new Exception("Future Dependant had an exception"));
                } else {
                    completableFuture.complete(list3);
                }
            }
        });
        return completableFuture;
    }

    private class TaskHolder<R, A> {
        private final TaskChain<?> chain;
        private final TaskChainTasks.Task<R, A> task;
        final Boolean async;
        private boolean executed = false;
        private boolean aborted = false;
        private final int actionIndex;

        private TaskHolder(TaskChain<?> taskChain2, Boolean bl, TaskChainTasks.Task<R, A> task) {
            this.actionIndex = TaskChain.this.actionIndex++;
            this.task = task;
            this.chain = taskChain2;
            this.async = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            Object object2 = ((TaskChain)this.chain).previous;
            ((TaskChain)this.chain).previous = null;
            TaskChain.this.currentActionIndex = this.actionIndex;
            TaskChain taskChain = (TaskChain)currentChain.get();
            try {
                currentChain.set(this.chain);
                if (this.task instanceof TaskChainTasks.FutureTask) {
                    CompletableFuture completableFuture = ((TaskChainTasks.FutureTask)this.task).runFuture(object2);
                    if (completableFuture == null) {
                        throw new NullPointerException("Must return a Future");
                    }
                    completableFuture.whenComplete((object, throwable) -> {
                        if (throwable != null) {
                            ((TaskChain)this.chain).handleError(throwable, this.task);
                            this.abort();
                        } else {
                            this.next(object);
                        }
                    });
                } else if (this.task instanceof TaskChainTasks.AsyncExecutingTask) {
                    ((TaskChainTasks.AsyncExecutingTask)this.task).runAsync(object2, this::next);
                } else {
                    this.next(this.task.run(object2));
                }
            }
            catch (Throwable throwable2) {
                if (throwable2 instanceof AbortChainException) {
                    this.abort();
                    return;
                }
                ((TaskChain)this.chain).handleError(throwable2, this.task);
                this.abort();
            }
            finally {
                if (taskChain != null) {
                    currentChain.set(taskChain);
                } else {
                    currentChain.remove();
                }
            }
        }

        private synchronized void abort() {
            this.aborted = true;
            ((TaskChain)this.chain).abortExecutingChain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void next(Object object) {
            TaskHolder taskHolder = this;
            synchronized (taskHolder) {
                if (this.aborted) {
                    this.chain.done(false);
                    return;
                }
                if (this.executed) {
                    this.chain.done(false);
                    throw new RuntimeException("This task has already been executed.");
                }
                this.executed = true;
            }
            ((TaskChain)this.chain).async = !TaskChain.this.impl.isMainThread();
            ((TaskChain)this.chain).previous = object;
            ((TaskChain)this.chain).nextTask();
        }
    }
}

