/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.taskchain;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import me.glaremasters.guilds.libs.taskchain.AsyncQueue;
import me.glaremasters.guilds.libs.taskchain.GameInterface;
import me.glaremasters.guilds.libs.taskchain.SharedTaskChain;
import me.glaremasters.guilds.libs.taskchain.TaskChain;
import me.glaremasters.guilds.libs.taskchain.TaskChainTasks;

public class TaskChainFactory {
    private final GameInterface impl;
    private final AsyncQueue asyncQueue;
    private final Map<String, Queue<SharedTaskChain>> sharedChains = new HashMap<String, Queue<SharedTaskChain>>();
    private volatile BiConsumer<Exception, TaskChainTasks.Task<?, ?>> defaultErrorHandler;
    volatile boolean shutdown = false;

    public TaskChainFactory(GameInterface gameInterface) {
        this.impl = gameInterface;
        this.asyncQueue = gameInterface.getAsyncQueue();
        gameInterface.registerShutdownHandler(this);
    }

    GameInterface getImplementation() {
        return this.impl;
    }

    public Map<String, Queue<SharedTaskChain>> getSharedChains() {
        return this.sharedChains;
    }

    public <T> TaskChain<T> newChain() {
        return new TaskChain(this);
    }

    public synchronized <T> TaskChain<T> newSharedChain(String string) {
        return new SharedTaskChain(string, this);
    }

    public BiConsumer<Exception, TaskChainTasks.Task<?, ?>> getDefaultErrorHandler() {
        return this.defaultErrorHandler;
    }

    public void setDefaultErrorHandler(BiConsumer<Exception, TaskChainTasks.Task<?, ?>> biConsumer) {
        this.defaultErrorHandler = biConsumer;
    }

    public void shutdown(int n, TimeUnit timeUnit) {
        this.shutdown = true;
        this.asyncQueue.shutdown(n, timeUnit);
    }
}

