/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.listeners;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.commands.BukkitCommandIssuer;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ChatListener
implements Listener {
    private final Map<UUID, ChatType> playerChatMap = Maps.newConcurrentMap();
    private final Guilds guilds;
    private final GuildHandler guildHandler;

    public ChatListener(Guilds guilds) {
        this.guilds = guilds;
        this.guildHandler = guilds.getGuildHandler();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)guilds);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChatLowest(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        Player player = asyncPlayerChatEvent.getPlayer();
        ChatType chatType = this.playerChatMap.get(player.getUniqueId());
        if (chatType == null) {
            return;
        }
        asyncPlayerChatEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChatHighest(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (!asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        Player player = asyncPlayerChatEvent.getPlayer();
        ChatType chatType = this.playerChatMap.get(player.getUniqueId());
        String string = asyncPlayerChatEvent.getMessage();
        if (chatType == null) {
            return;
        }
        Guild guild = this.guildHandler.getGuild((OfflinePlayer)player);
        if (guild == null) {
            return;
        }
        if (chatType.equals((Object)ChatType.GUILD)) {
            this.guildHandler.handleGuildChat(guild, player, string);
            return;
        }
        if (chatType.equals((Object)ChatType.ALLY)) {
            this.guildHandler.handleAllyChat(guild, player, string);
        }
    }

    @EventHandler
    public void onLogout(PlayerQuitEvent playerQuitEvent) {
        this.guildHandler.chatLogout(playerQuitEvent.getPlayer());
    }

    public void handleToggle(Player player, ChatType chatType) {
        BukkitCommandIssuer bukkitCommandIssuer = this.guilds.getCommandManager().getCommandIssuer(player);
        if (this.playerChatMap.containsKey(player.getUniqueId())) {
            ChatType chatType2 = this.playerChatMap.remove(player.getUniqueId());
            if (chatType2 == chatType) {
                bukkitCommandIssuer.sendInfo(Messages.CHAT__TOGGLED_OFF, "{type}", chatType.translate(player, this.guilds));
                return;
            }
            bukkitCommandIssuer.sendInfo(Messages.CHAT__TOGGLED_OFF, "{type}", chatType2.translate(player, this.guilds));
            bukkitCommandIssuer.sendInfo(Messages.CHAT__TOGGLED_ON, "{type}", chatType.translate(player, this.guilds));
            this.playerChatMap.put(player.getUniqueId(), chatType);
            return;
        }
        bukkitCommandIssuer.sendInfo(Messages.CHAT__TOGGLED_ON, "{type}", chatType.translate(player, this.guilds));
        this.playerChatMap.put(player.getUniqueId(), chatType);
    }

    public Map<UUID, ChatType> getPlayerChatMap() {
        return this.playerChatMap;
    }

    public static enum ChatType {
        GUILD(Messages.CHAT__TYPE_GUILD),
        ALLY(Messages.CHAT__TYPE_ALLY);

        private final Messages messageKey;

        private ChatType(Messages messages) {
            this.messageKey = messages;
        }

        public String translate(Player player, Guilds guilds) {
            return MessageUtils.asString(player, guilds.getCommandManager(), this.messageKey);
        }
    }
}

