/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.listeners;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.configuration.sections.TicketSettings;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.messages.Messages;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lme/glaremasters/guilds/listeners/TicketListener;", "Lorg/bukkit/event/Listener;", "guilds", "Lme/glaremasters/guilds/Guilds;", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "(Lme/glaremasters/guilds/Guilds;Lme/glaremasters/guilds/guild/GuildHandler;Lch/jalu/configme/SettingsManager;)V", "onUpgrade", "", "Lorg/bukkit/event/player/PlayerInteractEvent;", "Guilds"})
public final class TicketListener
implements Listener {
    @NotNull
    private final Guilds guilds;
    @NotNull
    private final GuildHandler guildHandler;
    @NotNull
    private final SettingsManager settingsManager;

    public TicketListener(@NotNull Guilds guilds, @NotNull GuildHandler guildHandler, @NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"guilds");
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"guildHandler");
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        this.guilds = guilds;
        this.guildHandler = guildHandler;
        this.settingsManager = settingsManager;
    }

    @EventHandler
    public final void onUpgrade(@NotNull PlayerInteractEvent playerInteractEvent) {
        Intrinsics.checkNotNullParameter((Object)playerInteractEvent, (String)"<this>");
        ItemStack itemStack = playerInteractEvent.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack itemStack2 = itemStack;
        Player player = playerInteractEvent.getPlayer();
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (!this.settingsManager.getProperty(TicketSettings.TICKET_ENABLED).booleanValue()) {
            return;
        }
        Guild guild = this.guildHandler.getGuild((OfflinePlayer)player2);
        if (guild == null) {
            return;
        }
        Guild guild2 = guild;
        if (!itemStack2.isSimilar(this.guildHandler.matchTicket(this.settingsManager))) {
            return;
        }
        if (this.guildHandler.isMaxTier(guild2)) {
            this.guilds.getCommandManager().getCommandIssuer(playerInteractEvent.getPlayer()).sendInfo(Messages.UPGRADE__TIER_MAX, new String[0]);
            return;
        }
        if (itemStack2.getAmount() > 1) {
            itemStack2.setAmount(itemStack2.getAmount() - 1);
        } else {
            playerInteractEvent.getPlayer().getInventory().setItemInHand(new ItemStack(Material.AIR));
        }
        this.guilds.getCommandManager().getCommandIssuer(playerInteractEvent.getPlayer()).sendInfo(Messages.UPGRADE__SUCCESS, new String[0]);
        this.guildHandler.removeGuildPermsFromAll(this.guilds.getPermissions(), guild2);
        this.guildHandler.upgradeTier(guild2);
        this.guildHandler.addGuildPermsToAll(this.guilds.getPermissions(), guild2);
    }
}

