/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.listeners;

import java.util.List;
import java.util.stream.Collectors;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.configuration.sections.GuildVaultSettings;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.commands.ACFBukkitUtil;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.messages.Messages;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;

public class VaultBlacklistListener
implements Listener {
    private final Guilds guilds;
    private final GuildHandler guildHandler;
    private final SettingsManager settingsManager;

    public VaultBlacklistListener(Guilds guilds, GuildHandler guildHandler, SettingsManager settingsManager) {
        this.guilds = guilds;
        this.guildHandler = guildHandler;
        this.settingsManager = settingsManager;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        if (inventoryCloseEvent.getPlayer() instanceof Player) {
            Player player = (Player)inventoryCloseEvent.getPlayer();
            this.guildHandler.getOpened().remove(player);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        if (!(inventoryClickEvent.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        Guild guild = this.guildHandler.getGuild((OfflinePlayer)player);
        if (guild == null || !this.guildHandler.getOpened().contains(player) || inventoryClickEvent.getClickedInventory() != null) {
            return;
        }
        this.guilds.getGuiHandler().getVaults().get(guild, player).open(inventoryClickEvent.getWhoClicked());
        this.guildHandler.getOpened().remove(player);
    }

    @EventHandler
    public void onItemClick(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.isCancelled()) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (!this.guildHandler.getOpened().contains(player)) {
            return;
        }
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        inventoryClickEvent.setCancelled(this.settingsManager.getProperty(GuildVaultSettings.BLACKLIST_MATERIALS).stream().anyMatch(string -> string.equalsIgnoreCase(itemStack.getType().name())));
        if (inventoryClickEvent.isCancelled()) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.VAULTS__BLACKLISTED, new String[0]);
            return;
        }
        if (!itemStack.hasItemMeta()) {
            return;
        }
        if (itemStack.getItemMeta().hasDisplayName()) {
            inventoryClickEvent.setCancelled(this.settingsManager.getProperty(GuildVaultSettings.BLACKLIST_NAMES).stream().anyMatch(string -> string.equalsIgnoreCase(ACFBukkitUtil.removeColors(itemStack.getItemMeta().getDisplayName()))));
        }
        if (inventoryClickEvent.isCancelled()) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.VAULTS__BLACKLISTED, new String[0]);
            return;
        }
        if (!itemStack.getItemMeta().hasLore()) {
            return;
        }
        List list2 = itemStack.getItemMeta().getLore().stream().map(ACFBukkitUtil::removeColors).collect(Collectors.toList());
        for (String string3 : this.settingsManager.getProperty(GuildVaultSettings.BLACKLIST_LORES)) {
            if (string3.equalsIgnoreCase("") || !list2.stream().anyMatch(string2 -> string2.contains(string3))) continue;
            inventoryClickEvent.setCancelled(true);
            break;
        }
        if (inventoryClickEvent.isCancelled()) {
            this.guilds.getCommandManager().getCommandIssuer(player).sendInfo(Messages.VAULTS__BLACKLISTED, new String[0]);
        }
    }
}

