/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.tasks;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.challenges.ChallengeHandler;
import me.glaremasters.guilds.configuration.sections.WarSettings;
import me.glaremasters.guilds.guild.GuildChallenge;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.tasks.GuildWarReadyTask;
import me.glaremasters.guilds.utils.WarUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GuildWarJoinTask
extends BukkitRunnable {
    private final Guilds guilds;
    private int timeLeft;
    private final int readyTime;
    private final List<UUID> players;
    private final String joinMsg;
    private final String readyMsg;
    private final GuildChallenge challenge;
    private final ChallengeHandler challengeHandler;
    private final String notifyType;

    public GuildWarJoinTask(Guilds guilds, int n, int n2, List<UUID> list2, String string, String string2, GuildChallenge guildChallenge, ChallengeHandler challengeHandler) {
        this.guilds = guilds;
        this.timeLeft = n;
        this.readyTime = n2;
        this.players = list2;
        this.joinMsg = string;
        this.readyMsg = string2;
        this.challenge = guildChallenge;
        this.challengeHandler = challengeHandler;
        this.notifyType = guilds.getSettingsHandler().getMainConf().getProperty(WarSettings.NOTIFY_TYPE);
    }

    public void run() {
        this.players.forEach(uUID -> {
            Player player = Bukkit.getPlayer((UUID)uUID);
            if (player != null) {
                WarUtils.notify(this.notifyType, this.joinMsg.replace("{amount}", String.valueOf(this.timeLeft)), this.guilds.getAdventure().player(player));
            }
        });
        --this.timeLeft;
        if (this.timeLeft == 0) {
            this.challenge.setJoinble(false);
            if (!this.challengeHandler.checkEnoughJoined(this.challenge)) {
                this.challenge.getChallenger().sendMessage(this.guilds.getCommandManager(), Messages.WAR__NOT_ENOUGH_JOINED, new String[0]);
                this.challenge.getDefender().sendMessage(this.guilds.getCommandManager(), Messages.WAR__NOT_ENOUGH_JOINED, new String[0]);
                this.challenge.getArena().setInUse(false);
                this.challengeHandler.removeChallenge(this.challenge.getId());
                this.cancel();
                return;
            }
            List<UUID> list2 = Stream.concat(this.challenge.getChallengePlayers().stream(), this.challenge.getDefendPlayers().stream()).collect(Collectors.toList());
            new GuildWarReadyTask(this.guilds, this.readyTime, list2, this.readyMsg, this.challenge, this.challengeHandler).runTaskTimer((Plugin)this.guilds, 0L, 20L);
            this.cancel();
        }
    }
}

